package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AzureFunctionsAuthentication implements com.commercetools.graphql.api.types.HttpDestinationAuthentication {
  private String key;

  private String type;

  public AzureFunctionsAuthentication() {
  }

  public AzureFunctionsAuthentication(String key, String type) {
    this.key = key;
    this.type = type;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AzureFunctionsAuthentication{key='" + key + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AzureFunctionsAuthentication that = (AzureFunctionsAuthentication) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String type;

    public AzureFunctionsAuthentication build() {
      AzureFunctionsAuthentication result = new AzureFunctionsAuthentication();
      result.key = this.key;
      result.type = this.type;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
