package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AzureServiceBusDestinationInput {
  private String connectionString;

  public AzureServiceBusDestinationInput() {
  }

  public AzureServiceBusDestinationInput(String connectionString) {
    this.connectionString = connectionString;
  }

  public String getConnectionString() {
    return connectionString;
  }

  public void setConnectionString(String connectionString) {
    this.connectionString = connectionString;
  }

  @Override
  public String toString() {
    return "AzureServiceBusDestinationInput{connectionString='" + connectionString + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AzureServiceBusDestinationInput that = (AzureServiceBusDestinationInput) o;
    return Objects.equals(connectionString, that.connectionString);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectionString);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String connectionString;

    public AzureServiceBusDestinationInput build() {
      AzureServiceBusDestinationInput result = new AzureServiceBusDestinationInput();
      result.connectionString = this.connectionString;
      return result;
    }

    public Builder connectionString(String connectionString) {
      this.connectionString = connectionString;
      return this;
    }
  }
}
