package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BestDeal implements com.commercetools.graphql.api.types.DiscountTypeCombination {
  private String type;

  private ChosenDiscountType chosenDiscountType;

  public BestDeal() {
  }

  public BestDeal(String type, ChosenDiscountType chosenDiscountType) {
    this.type = type;
    this.chosenDiscountType = chosenDiscountType;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ChosenDiscountType getChosenDiscountType() {
    return chosenDiscountType;
  }

  public void setChosenDiscountType(ChosenDiscountType chosenDiscountType) {
    this.chosenDiscountType = chosenDiscountType;
  }

  @Override
  public String toString() {
    return "BestDeal{type='" + type + "', chosenDiscountType='" + chosenDiscountType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BestDeal that = (BestDeal) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(chosenDiscountType, that.chosenDiscountType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, chosenDiscountType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ChosenDiscountType chosenDiscountType;

    public BestDeal build() {
      BestDeal result = new BestDeal();
      result.type = this.type;
      result.chosenDiscountType = this.chosenDiscountType;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder chosenDiscountType(ChosenDiscountType chosenDiscountType) {
      this.chosenDiscountType = chosenDiscountType;
      return this;
    }
  }
}
