package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnit implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String key;

  private String name;

  private String contactEmail;

  private List<Address> addresses;

  private Address defaultShippingAddress;

  private Address defaultBillingAddress;

  private String defaultShippingAddressId;

  private String defaultBillingAddressId;

  private List<Address> shippingAddresses;

  private List<Address> billingAddresses;

  private List<String> shippingAddressIds;

  private List<String> billingAddressIds;

  private BusinessUnitStatus status;

  private List<KeyReference> storesRef;

  private List<Store> stores;

  private String storeMode;

  private BusinessUnitType unitType;

  private List<Associate> associates;

  private BusinessUnitAssociateMode associateMode;

  private List<InheritedAssociate> inheritedAssociates;

  private CustomFieldsType custom;

  private KeyReference parentUnitRef;

  private BusinessUnit parentUnit;

  /**
   * This field contains the BusinessUnits KeyReferences from the Company to the parent Division of this BusinessUnit in that order.
   */
  private List<BusinessUnit> ancestors;

  /**
   * This field contains the inherited stores from its parentUnit if storeMode is set to FromParent.
   */
  private List<InheritedStore> inheritedStores;

  private KeyReference topLevelUnitRef;

  private BusinessUnit topLevelUnit;

  private BusinessUnitApprovalRuleMode approvalRuleMode;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public BusinessUnit() {
  }

  public BusinessUnit(String key, String name, String contactEmail, List<Address> addresses,
      Address defaultShippingAddress, Address defaultBillingAddress,
      String defaultShippingAddressId, String defaultBillingAddressId,
      List<Address> shippingAddresses, List<Address> billingAddresses,
      List<String> shippingAddressIds, List<String> billingAddressIds, BusinessUnitStatus status,
      List<KeyReference> storesRef, List<Store> stores, String storeMode, BusinessUnitType unitType,
      List<Associate> associates, BusinessUnitAssociateMode associateMode,
      List<InheritedAssociate> inheritedAssociates, CustomFieldsType custom,
      KeyReference parentUnitRef, BusinessUnit parentUnit, List<BusinessUnit> ancestors,
      List<InheritedStore> inheritedStores, KeyReference topLevelUnitRef, BusinessUnit topLevelUnit,
      BusinessUnitApprovalRuleMode approvalRuleMode, String id, Long version,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.key = key;
    this.name = name;
    this.contactEmail = contactEmail;
    this.addresses = addresses;
    this.defaultShippingAddress = defaultShippingAddress;
    this.defaultBillingAddress = defaultBillingAddress;
    this.defaultShippingAddressId = defaultShippingAddressId;
    this.defaultBillingAddressId = defaultBillingAddressId;
    this.shippingAddresses = shippingAddresses;
    this.billingAddresses = billingAddresses;
    this.shippingAddressIds = shippingAddressIds;
    this.billingAddressIds = billingAddressIds;
    this.status = status;
    this.storesRef = storesRef;
    this.stores = stores;
    this.storeMode = storeMode;
    this.unitType = unitType;
    this.associates = associates;
    this.associateMode = associateMode;
    this.inheritedAssociates = inheritedAssociates;
    this.custom = custom;
    this.parentUnitRef = parentUnitRef;
    this.parentUnit = parentUnit;
    this.ancestors = ancestors;
    this.inheritedStores = inheritedStores;
    this.topLevelUnitRef = topLevelUnitRef;
    this.topLevelUnit = topLevelUnit;
    this.approvalRuleMode = approvalRuleMode;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getContactEmail() {
    return contactEmail;
  }

  public void setContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
  }

  public List<Address> getAddresses() {
    return addresses;
  }

  public void setAddresses(List<Address> addresses) {
    this.addresses = addresses;
  }

  public Address getDefaultShippingAddress() {
    return defaultShippingAddress;
  }

  public void setDefaultShippingAddress(Address defaultShippingAddress) {
    this.defaultShippingAddress = defaultShippingAddress;
  }

  public Address getDefaultBillingAddress() {
    return defaultBillingAddress;
  }

  public void setDefaultBillingAddress(Address defaultBillingAddress) {
    this.defaultBillingAddress = defaultBillingAddress;
  }

  public String getDefaultShippingAddressId() {
    return defaultShippingAddressId;
  }

  public void setDefaultShippingAddressId(String defaultShippingAddressId) {
    this.defaultShippingAddressId = defaultShippingAddressId;
  }

  public String getDefaultBillingAddressId() {
    return defaultBillingAddressId;
  }

  public void setDefaultBillingAddressId(String defaultBillingAddressId) {
    this.defaultBillingAddressId = defaultBillingAddressId;
  }

  public List<Address> getShippingAddresses() {
    return shippingAddresses;
  }

  public void setShippingAddresses(List<Address> shippingAddresses) {
    this.shippingAddresses = shippingAddresses;
  }

  public List<Address> getBillingAddresses() {
    return billingAddresses;
  }

  public void setBillingAddresses(List<Address> billingAddresses) {
    this.billingAddresses = billingAddresses;
  }

  public List<String> getShippingAddressIds() {
    return shippingAddressIds;
  }

  public void setShippingAddressIds(List<String> shippingAddressIds) {
    this.shippingAddressIds = shippingAddressIds;
  }

  public List<String> getBillingAddressIds() {
    return billingAddressIds;
  }

  public void setBillingAddressIds(List<String> billingAddressIds) {
    this.billingAddressIds = billingAddressIds;
  }

  public BusinessUnitStatus getStatus() {
    return status;
  }

  public void setStatus(BusinessUnitStatus status) {
    this.status = status;
  }

  public List<KeyReference> getStoresRef() {
    return storesRef;
  }

  public void setStoresRef(List<KeyReference> storesRef) {
    this.storesRef = storesRef;
  }

  public List<Store> getStores() {
    return stores;
  }

  public void setStores(List<Store> stores) {
    this.stores = stores;
  }

  public String getStoreMode() {
    return storeMode;
  }

  public void setStoreMode(String storeMode) {
    this.storeMode = storeMode;
  }

  public BusinessUnitType getUnitType() {
    return unitType;
  }

  public void setUnitType(BusinessUnitType unitType) {
    this.unitType = unitType;
  }

  public List<Associate> getAssociates() {
    return associates;
  }

  public void setAssociates(List<Associate> associates) {
    this.associates = associates;
  }

  public BusinessUnitAssociateMode getAssociateMode() {
    return associateMode;
  }

  public void setAssociateMode(BusinessUnitAssociateMode associateMode) {
    this.associateMode = associateMode;
  }

  public List<InheritedAssociate> getInheritedAssociates() {
    return inheritedAssociates;
  }

  public void setInheritedAssociates(List<InheritedAssociate> inheritedAssociates) {
    this.inheritedAssociates = inheritedAssociates;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public KeyReference getParentUnitRef() {
    return parentUnitRef;
  }

  public void setParentUnitRef(KeyReference parentUnitRef) {
    this.parentUnitRef = parentUnitRef;
  }

  public BusinessUnit getParentUnit() {
    return parentUnit;
  }

  public void setParentUnit(BusinessUnit parentUnit) {
    this.parentUnit = parentUnit;
  }

  /**
   * This field contains the BusinessUnits KeyReferences from the Company to the parent Division of this BusinessUnit in that order.
   */
  public List<BusinessUnit> getAncestors() {
    return ancestors;
  }

  public void setAncestors(List<BusinessUnit> ancestors) {
    this.ancestors = ancestors;
  }

  /**
   * This field contains the inherited stores from its parentUnit if storeMode is set to FromParent.
   */
  public List<InheritedStore> getInheritedStores() {
    return inheritedStores;
  }

  public void setInheritedStores(List<InheritedStore> inheritedStores) {
    this.inheritedStores = inheritedStores;
  }

  public KeyReference getTopLevelUnitRef() {
    return topLevelUnitRef;
  }

  public void setTopLevelUnitRef(KeyReference topLevelUnitRef) {
    this.topLevelUnitRef = topLevelUnitRef;
  }

  public BusinessUnit getTopLevelUnit() {
    return topLevelUnit;
  }

  public void setTopLevelUnit(BusinessUnit topLevelUnit) {
    this.topLevelUnit = topLevelUnit;
  }

  public BusinessUnitApprovalRuleMode getApprovalRuleMode() {
    return approvalRuleMode;
  }

  public void setApprovalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
    this.approvalRuleMode = approvalRuleMode;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "BusinessUnit{key='" + key + "', name='" + name + "', contactEmail='" + contactEmail + "', addresses='" + addresses + "', defaultShippingAddress='" + defaultShippingAddress + "', defaultBillingAddress='" + defaultBillingAddress + "', defaultShippingAddressId='" + defaultShippingAddressId + "', defaultBillingAddressId='" + defaultBillingAddressId + "', shippingAddresses='" + shippingAddresses + "', billingAddresses='" + billingAddresses + "', shippingAddressIds='" + shippingAddressIds + "', billingAddressIds='" + billingAddressIds + "', status='" + status + "', storesRef='" + storesRef + "', stores='" + stores + "', storeMode='" + storeMode + "', unitType='" + unitType + "', associates='" + associates + "', associateMode='" + associateMode + "', inheritedAssociates='" + inheritedAssociates + "', custom='" + custom + "', parentUnitRef='" + parentUnitRef + "', parentUnit='" + parentUnit + "', ancestors='" + ancestors + "', inheritedStores='" + inheritedStores + "', topLevelUnitRef='" + topLevelUnitRef + "', topLevelUnit='" + topLevelUnit + "', approvalRuleMode='" + approvalRuleMode + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnit that = (BusinessUnit) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(contactEmail, that.contactEmail) &&
        Objects.equals(addresses, that.addresses) &&
        Objects.equals(defaultShippingAddress, that.defaultShippingAddress) &&
        Objects.equals(defaultBillingAddress, that.defaultBillingAddress) &&
        Objects.equals(defaultShippingAddressId, that.defaultShippingAddressId) &&
        Objects.equals(defaultBillingAddressId, that.defaultBillingAddressId) &&
        Objects.equals(shippingAddresses, that.shippingAddresses) &&
        Objects.equals(billingAddresses, that.billingAddresses) &&
        Objects.equals(shippingAddressIds, that.shippingAddressIds) &&
        Objects.equals(billingAddressIds, that.billingAddressIds) &&
        Objects.equals(status, that.status) &&
        Objects.equals(storesRef, that.storesRef) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(storeMode, that.storeMode) &&
        Objects.equals(unitType, that.unitType) &&
        Objects.equals(associates, that.associates) &&
        Objects.equals(associateMode, that.associateMode) &&
        Objects.equals(inheritedAssociates, that.inheritedAssociates) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(parentUnitRef, that.parentUnitRef) &&
        Objects.equals(parentUnit, that.parentUnit) &&
        Objects.equals(ancestors, that.ancestors) &&
        Objects.equals(inheritedStores, that.inheritedStores) &&
        Objects.equals(topLevelUnitRef, that.topLevelUnitRef) &&
        Objects.equals(topLevelUnit, that.topLevelUnit) &&
        Objects.equals(approvalRuleMode, that.approvalRuleMode) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, contactEmail, addresses, defaultShippingAddress, defaultBillingAddress, defaultShippingAddressId, defaultBillingAddressId, shippingAddresses, billingAddresses, shippingAddressIds, billingAddressIds, status, storesRef, stores, storeMode, unitType, associates, associateMode, inheritedAssociates, custom, parentUnitRef, parentUnit, ancestors, inheritedStores, topLevelUnitRef, topLevelUnit, approvalRuleMode, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private String contactEmail;

    private List<Address> addresses;

    private Address defaultShippingAddress;

    private Address defaultBillingAddress;

    private String defaultShippingAddressId;

    private String defaultBillingAddressId;

    private List<Address> shippingAddresses;

    private List<Address> billingAddresses;

    private List<String> shippingAddressIds;

    private List<String> billingAddressIds;

    private BusinessUnitStatus status;

    private List<KeyReference> storesRef;

    private List<Store> stores;

    private String storeMode;

    private BusinessUnitType unitType;

    private List<Associate> associates;

    private BusinessUnitAssociateMode associateMode;

    private List<InheritedAssociate> inheritedAssociates;

    private CustomFieldsType custom;

    private KeyReference parentUnitRef;

    private BusinessUnit parentUnit;

    /**
     * This field contains the BusinessUnits KeyReferences from the Company to the parent Division of this BusinessUnit in that order.
     */
    private List<BusinessUnit> ancestors;

    /**
     * This field contains the inherited stores from its parentUnit if storeMode is set to FromParent.
     */
    private List<InheritedStore> inheritedStores;

    private KeyReference topLevelUnitRef;

    private BusinessUnit topLevelUnit;

    private BusinessUnitApprovalRuleMode approvalRuleMode;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public BusinessUnit build() {
      BusinessUnit result = new BusinessUnit();
      result.key = this.key;
      result.name = this.name;
      result.contactEmail = this.contactEmail;
      result.addresses = this.addresses;
      result.defaultShippingAddress = this.defaultShippingAddress;
      result.defaultBillingAddress = this.defaultBillingAddress;
      result.defaultShippingAddressId = this.defaultShippingAddressId;
      result.defaultBillingAddressId = this.defaultBillingAddressId;
      result.shippingAddresses = this.shippingAddresses;
      result.billingAddresses = this.billingAddresses;
      result.shippingAddressIds = this.shippingAddressIds;
      result.billingAddressIds = this.billingAddressIds;
      result.status = this.status;
      result.storesRef = this.storesRef;
      result.stores = this.stores;
      result.storeMode = this.storeMode;
      result.unitType = this.unitType;
      result.associates = this.associates;
      result.associateMode = this.associateMode;
      result.inheritedAssociates = this.inheritedAssociates;
      result.custom = this.custom;
      result.parentUnitRef = this.parentUnitRef;
      result.parentUnit = this.parentUnit;
      result.ancestors = this.ancestors;
      result.inheritedStores = this.inheritedStores;
      result.topLevelUnitRef = this.topLevelUnitRef;
      result.topLevelUnit = this.topLevelUnit;
      result.approvalRuleMode = this.approvalRuleMode;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder contactEmail(String contactEmail) {
      this.contactEmail = contactEmail;
      return this;
    }

    public Builder addresses(List<Address> addresses) {
      this.addresses = addresses;
      return this;
    }

    public Builder defaultShippingAddress(Address defaultShippingAddress) {
      this.defaultShippingAddress = defaultShippingAddress;
      return this;
    }

    public Builder defaultBillingAddress(Address defaultBillingAddress) {
      this.defaultBillingAddress = defaultBillingAddress;
      return this;
    }

    public Builder defaultShippingAddressId(String defaultShippingAddressId) {
      this.defaultShippingAddressId = defaultShippingAddressId;
      return this;
    }

    public Builder defaultBillingAddressId(String defaultBillingAddressId) {
      this.defaultBillingAddressId = defaultBillingAddressId;
      return this;
    }

    public Builder shippingAddresses(List<Address> shippingAddresses) {
      this.shippingAddresses = shippingAddresses;
      return this;
    }

    public Builder billingAddresses(List<Address> billingAddresses) {
      this.billingAddresses = billingAddresses;
      return this;
    }

    public Builder shippingAddressIds(List<String> shippingAddressIds) {
      this.shippingAddressIds = shippingAddressIds;
      return this;
    }

    public Builder billingAddressIds(List<String> billingAddressIds) {
      this.billingAddressIds = billingAddressIds;
      return this;
    }

    public Builder status(BusinessUnitStatus status) {
      this.status = status;
      return this;
    }

    public Builder storesRef(List<KeyReference> storesRef) {
      this.storesRef = storesRef;
      return this;
    }

    public Builder stores(List<Store> stores) {
      this.stores = stores;
      return this;
    }

    public Builder storeMode(String storeMode) {
      this.storeMode = storeMode;
      return this;
    }

    public Builder unitType(BusinessUnitType unitType) {
      this.unitType = unitType;
      return this;
    }

    public Builder associates(List<Associate> associates) {
      this.associates = associates;
      return this;
    }

    public Builder associateMode(BusinessUnitAssociateMode associateMode) {
      this.associateMode = associateMode;
      return this;
    }

    public Builder inheritedAssociates(List<InheritedAssociate> inheritedAssociates) {
      this.inheritedAssociates = inheritedAssociates;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder parentUnitRef(KeyReference parentUnitRef) {
      this.parentUnitRef = parentUnitRef;
      return this;
    }

    public Builder parentUnit(BusinessUnit parentUnit) {
      this.parentUnit = parentUnit;
      return this;
    }

    /**
     * This field contains the BusinessUnits KeyReferences from the Company to the parent Division of this BusinessUnit in that order.
     */
    public Builder ancestors(List<BusinessUnit> ancestors) {
      this.ancestors = ancestors;
      return this;
    }

    /**
     * This field contains the inherited stores from its parentUnit if storeMode is set to FromParent.
     */
    public Builder inheritedStores(List<InheritedStore> inheritedStores) {
      this.inheritedStores = inheritedStores;
      return this;
    }

    public Builder topLevelUnitRef(KeyReference topLevelUnitRef) {
      this.topLevelUnitRef = topLevelUnitRef;
      return this;
    }

    public Builder topLevelUnit(BusinessUnit topLevelUnit) {
      this.topLevelUnit = topLevelUnit;
      return this;
    }

    public Builder approvalRuleMode(BusinessUnitApprovalRuleMode approvalRuleMode) {
      this.approvalRuleMode = approvalRuleMode;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
