package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitAddressCustomFieldChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private String name;

  private JsonNode value;

  private JsonNode oldValue;

  private String addressId;

  private String type;

  public BusinessUnitAddressCustomFieldChanged() {
  }

  public BusinessUnitAddressCustomFieldChanged(String name, JsonNode value, JsonNode oldValue,
      String addressId, String type) {
    this.name = name;
    this.value = value;
    this.oldValue = oldValue;
    this.addressId = addressId;
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public JsonNode getOldValue() {
    return oldValue;
  }

  public void setOldValue(JsonNode oldValue) {
    this.oldValue = oldValue;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitAddressCustomFieldChanged{name='" + name + "', value='" + value + "', oldValue='" + oldValue + "', addressId='" + addressId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitAddressCustomFieldChanged that = (BusinessUnitAddressCustomFieldChanged) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(oldValue, that.oldValue) &&
        Objects.equals(addressId, that.addressId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, oldValue, addressId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private JsonNode value;

    private JsonNode oldValue;

    private String addressId;

    private String type;

    public BusinessUnitAddressCustomFieldChanged build() {
      BusinessUnitAddressCustomFieldChanged result = new BusinessUnitAddressCustomFieldChanged();
      result.name = this.name;
      result.value = this.value;
      result.oldValue = this.oldValue;
      result.addressId = this.addressId;
      result.type = this.type;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder oldValue(JsonNode oldValue) {
      this.oldValue = oldValue;
      return this;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
