package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitAddressCustomTypeSet implements com.commercetools.graphql.api.types.MessagePayload {
  private CustomFieldsType customFields;

  private String oldTypeId;

  private String addressId;

  private String type;

  public BusinessUnitAddressCustomTypeSet() {
  }

  public BusinessUnitAddressCustomTypeSet(CustomFieldsType customFields, String oldTypeId,
      String addressId, String type) {
    this.customFields = customFields;
    this.oldTypeId = oldTypeId;
    this.addressId = addressId;
    this.type = type;
  }

  public CustomFieldsType getCustomFields() {
    return customFields;
  }

  public void setCustomFields(CustomFieldsType customFields) {
    this.customFields = customFields;
  }

  public String getOldTypeId() {
    return oldTypeId;
  }

  public void setOldTypeId(String oldTypeId) {
    this.oldTypeId = oldTypeId;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitAddressCustomTypeSet{customFields='" + customFields + "', oldTypeId='" + oldTypeId + "', addressId='" + addressId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitAddressCustomTypeSet that = (BusinessUnitAddressCustomTypeSet) o;
    return Objects.equals(customFields, that.customFields) &&
        Objects.equals(oldTypeId, that.oldTypeId) &&
        Objects.equals(addressId, that.addressId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customFields, oldTypeId, addressId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomFieldsType customFields;

    private String oldTypeId;

    private String addressId;

    private String type;

    public BusinessUnitAddressCustomTypeSet build() {
      BusinessUnitAddressCustomTypeSet result = new BusinessUnitAddressCustomTypeSet();
      result.customFields = this.customFields;
      result.oldTypeId = this.oldTypeId;
      result.addressId = this.addressId;
      result.type = this.type;
      return result;
    }

    public Builder customFields(CustomFieldsType customFields) {
      this.customFields = customFields;
      return this;
    }

    public Builder oldTypeId(String oldTypeId) {
      this.oldTypeId = oldTypeId;
      return this;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
