package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitAssociatesSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<Associate> associates;

  private String type;

  public BusinessUnitAssociatesSet() {
  }

  public BusinessUnitAssociatesSet(List<Associate> associates, String type) {
    this.associates = associates;
    this.type = type;
  }

  public List<Associate> getAssociates() {
    return associates;
  }

  public void setAssociates(List<Associate> associates) {
    this.associates = associates;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitAssociatesSet{associates='" + associates + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitAssociatesSet that = (BusinessUnitAssociatesSet) o;
    return Objects.equals(associates, that.associates) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associates, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Associate> associates;

    private String type;

    public BusinessUnitAssociatesSet build() {
      BusinessUnitAssociatesSet result = new BusinessUnitAssociatesSet();
      result.associates = this.associates;
      result.type = this.type;
      return result;
    }

    public Builder associates(List<Associate> associates) {
      this.associates = associates;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
