package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class BusinessUnitConfiguration {
  private BusinessUnitConfigurationStatus myBusinessUnitStatusOnCreation;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private KeyReference myBusinessUnitAssociateRoleOnCreationRef;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private AssociateRole myBusinessUnitAssociateRoleOnCreation;

  public BusinessUnitConfiguration() {
  }

  public BusinessUnitConfiguration(BusinessUnitConfigurationStatus myBusinessUnitStatusOnCreation,
      KeyReference myBusinessUnitAssociateRoleOnCreationRef,
      AssociateRole myBusinessUnitAssociateRoleOnCreation) {
    this.myBusinessUnitStatusOnCreation = myBusinessUnitStatusOnCreation;
    this.myBusinessUnitAssociateRoleOnCreationRef = myBusinessUnitAssociateRoleOnCreationRef;
    this.myBusinessUnitAssociateRoleOnCreation = myBusinessUnitAssociateRoleOnCreation;
  }

  public BusinessUnitConfigurationStatus getMyBusinessUnitStatusOnCreation() {
    return myBusinessUnitStatusOnCreation;
  }

  public void setMyBusinessUnitStatusOnCreation(
      BusinessUnitConfigurationStatus myBusinessUnitStatusOnCreation) {
    this.myBusinessUnitStatusOnCreation = myBusinessUnitStatusOnCreation;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public KeyReference getMyBusinessUnitAssociateRoleOnCreationRef() {
    return myBusinessUnitAssociateRoleOnCreationRef;
  }

  public void setMyBusinessUnitAssociateRoleOnCreationRef(
      KeyReference myBusinessUnitAssociateRoleOnCreationRef) {
    this.myBusinessUnitAssociateRoleOnCreationRef = myBusinessUnitAssociateRoleOnCreationRef;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public AssociateRole getMyBusinessUnitAssociateRoleOnCreation() {
    return myBusinessUnitAssociateRoleOnCreation;
  }

  public void setMyBusinessUnitAssociateRoleOnCreation(
      AssociateRole myBusinessUnitAssociateRoleOnCreation) {
    this.myBusinessUnitAssociateRoleOnCreation = myBusinessUnitAssociateRoleOnCreation;
  }

  @Override
  public String toString() {
    return "BusinessUnitConfiguration{myBusinessUnitStatusOnCreation='" + myBusinessUnitStatusOnCreation + "', myBusinessUnitAssociateRoleOnCreationRef='" + myBusinessUnitAssociateRoleOnCreationRef + "', myBusinessUnitAssociateRoleOnCreation='" + myBusinessUnitAssociateRoleOnCreation + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitConfiguration that = (BusinessUnitConfiguration) o;
    return Objects.equals(myBusinessUnitStatusOnCreation, that.myBusinessUnitStatusOnCreation) &&
        Objects.equals(myBusinessUnitAssociateRoleOnCreationRef, that.myBusinessUnitAssociateRoleOnCreationRef) &&
        Objects.equals(myBusinessUnitAssociateRoleOnCreation, that.myBusinessUnitAssociateRoleOnCreation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(myBusinessUnitStatusOnCreation, myBusinessUnitAssociateRoleOnCreationRef, myBusinessUnitAssociateRoleOnCreation);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitConfigurationStatus myBusinessUnitStatusOnCreation;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private KeyReference myBusinessUnitAssociateRoleOnCreationRef;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private AssociateRole myBusinessUnitAssociateRoleOnCreation;

    public BusinessUnitConfiguration build() {
      BusinessUnitConfiguration result = new BusinessUnitConfiguration();
      result.myBusinessUnitStatusOnCreation = this.myBusinessUnitStatusOnCreation;
      result.myBusinessUnitAssociateRoleOnCreationRef = this.myBusinessUnitAssociateRoleOnCreationRef;
      result.myBusinessUnitAssociateRoleOnCreation = this.myBusinessUnitAssociateRoleOnCreation;
      return result;
    }

    public Builder myBusinessUnitStatusOnCreation(
        BusinessUnitConfigurationStatus myBusinessUnitStatusOnCreation) {
      this.myBusinessUnitStatusOnCreation = myBusinessUnitStatusOnCreation;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder myBusinessUnitAssociateRoleOnCreationRef(
        KeyReference myBusinessUnitAssociateRoleOnCreationRef) {
      this.myBusinessUnitAssociateRoleOnCreationRef = myBusinessUnitAssociateRoleOnCreationRef;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder myBusinessUnitAssociateRoleOnCreation(
        AssociateRole myBusinessUnitAssociateRoleOnCreation) {
      this.myBusinessUnitAssociateRoleOnCreation = myBusinessUnitAssociateRoleOnCreation;
      return this;
    }
  }
}
