package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitContactEmailSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String contactEmail;

  private String type;

  public BusinessUnitContactEmailSet() {
  }

  public BusinessUnitContactEmailSet(String contactEmail, String type) {
    this.contactEmail = contactEmail;
    this.type = type;
  }

  public String getContactEmail() {
    return contactEmail;
  }

  public void setContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitContactEmailSet{contactEmail='" + contactEmail + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitContactEmailSet that = (BusinessUnitContactEmailSet) o;
    return Objects.equals(contactEmail, that.contactEmail) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactEmail, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String contactEmail;

    private String type;

    public BusinessUnitContactEmailSet build() {
      BusinessUnitContactEmailSet result = new BusinessUnitContactEmailSet();
      result.contactEmail = this.contactEmail;
      result.type = this.type;
      return result;
    }

    public Builder contactEmail(String contactEmail) {
      this.contactEmail = contactEmail;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
