package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private BusinessUnit businessUnit;

  private String type;

  public BusinessUnitCreated() {
  }

  public BusinessUnitCreated(BusinessUnit businessUnit, String type) {
    this.businessUnit = businessUnit;
    this.type = type;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitCreated{businessUnit='" + businessUnit + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitCreated that = (BusinessUnitCreated) o;
    return Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessUnit, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnit businessUnit;

    private String type;

    public BusinessUnitCreated build() {
      BusinessUnitCreated result = new BusinessUnitCreated();
      result.businessUnit = this.businessUnit;
      result.type = this.type;
      return result;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
