package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitStatusChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private BusinessUnitStatus status;

  private String type;

  public BusinessUnitStatusChanged() {
  }

  public BusinessUnitStatusChanged(BusinessUnitStatus status, String type) {
    this.status = status;
    this.type = type;
  }

  public BusinessUnitStatus getStatus() {
    return status;
  }

  public void setStatus(BusinessUnitStatus status) {
    this.status = status;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitStatusChanged{status='" + status + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitStatusChanged that = (BusinessUnitStatusChanged) o;
    return Objects.equals(status, that.status) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitStatus status;

    private String type;

    public BusinessUnitStatusChanged build() {
      BusinessUnitStatusChanged result = new BusinessUnitStatusChanged();
      result.status = this.status;
      result.type = this.type;
      return result;
    }

    public Builder status(BusinessUnitStatus status) {
      this.status = status;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
