package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitStoreAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private Store store;

  private KeyReference storeRef;

  private String type;

  public BusinessUnitStoreAdded() {
  }

  public BusinessUnitStoreAdded(Store store, KeyReference storeRef, String type) {
    this.store = store;
    this.storeRef = storeRef;
    this.type = type;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitStoreAdded{store='" + store + "', storeRef='" + storeRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitStoreAdded that = (BusinessUnitStoreAdded) o;
    return Objects.equals(store, that.store) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(store, storeRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Store store;

    private KeyReference storeRef;

    private String type;

    public BusinessUnitStoreAdded build() {
      BusinessUnitStoreAdded result = new BusinessUnitStoreAdded();
      result.store = this.store;
      result.storeRef = this.storeRef;
      result.type = this.type;
      return result;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
