package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class BusinessUnitStoreModeChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private String storeMode;

  private String oldStoreMode;

  private List<Store> stores;

  private List<Store> oldStores;

  private List<KeyReference> storesRef;

  private List<KeyReference> oldStoresRef;

  private String type;

  public BusinessUnitStoreModeChanged() {
  }

  public BusinessUnitStoreModeChanged(String storeMode, String oldStoreMode, List<Store> stores,
      List<Store> oldStores, List<KeyReference> storesRef, List<KeyReference> oldStoresRef,
      String type) {
    this.storeMode = storeMode;
    this.oldStoreMode = oldStoreMode;
    this.stores = stores;
    this.oldStores = oldStores;
    this.storesRef = storesRef;
    this.oldStoresRef = oldStoresRef;
    this.type = type;
  }

  public String getStoreMode() {
    return storeMode;
  }

  public void setStoreMode(String storeMode) {
    this.storeMode = storeMode;
  }

  public String getOldStoreMode() {
    return oldStoreMode;
  }

  public void setOldStoreMode(String oldStoreMode) {
    this.oldStoreMode = oldStoreMode;
  }

  public List<Store> getStores() {
    return stores;
  }

  public void setStores(List<Store> stores) {
    this.stores = stores;
  }

  public List<Store> getOldStores() {
    return oldStores;
  }

  public void setOldStores(List<Store> oldStores) {
    this.oldStores = oldStores;
  }

  public List<KeyReference> getStoresRef() {
    return storesRef;
  }

  public void setStoresRef(List<KeyReference> storesRef) {
    this.storesRef = storesRef;
  }

  public List<KeyReference> getOldStoresRef() {
    return oldStoresRef;
  }

  public void setOldStoresRef(List<KeyReference> oldStoresRef) {
    this.oldStoresRef = oldStoresRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "BusinessUnitStoreModeChanged{storeMode='" + storeMode + "', oldStoreMode='" + oldStoreMode + "', stores='" + stores + "', oldStores='" + oldStores + "', storesRef='" + storesRef + "', oldStoresRef='" + oldStoresRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitStoreModeChanged that = (BusinessUnitStoreModeChanged) o;
    return Objects.equals(storeMode, that.storeMode) &&
        Objects.equals(oldStoreMode, that.oldStoreMode) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(oldStores, that.oldStores) &&
        Objects.equals(storesRef, that.storesRef) &&
        Objects.equals(oldStoresRef, that.oldStoresRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(storeMode, oldStoreMode, stores, oldStores, storesRef, oldStoresRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String storeMode;

    private String oldStoreMode;

    private List<Store> stores;

    private List<Store> oldStores;

    private List<KeyReference> storesRef;

    private List<KeyReference> oldStoresRef;

    private String type;

    public BusinessUnitStoreModeChanged build() {
      BusinessUnitStoreModeChanged result = new BusinessUnitStoreModeChanged();
      result.storeMode = this.storeMode;
      result.oldStoreMode = this.oldStoreMode;
      result.stores = this.stores;
      result.oldStores = this.oldStores;
      result.storesRef = this.storesRef;
      result.oldStoresRef = this.oldStoresRef;
      result.type = this.type;
      return result;
    }

    public Builder storeMode(String storeMode) {
      this.storeMode = storeMode;
      return this;
    }

    public Builder oldStoreMode(String oldStoreMode) {
      this.oldStoreMode = oldStoreMode;
      return this;
    }

    public Builder stores(List<Store> stores) {
      this.stores = stores;
      return this;
    }

    public Builder oldStores(List<Store> oldStores) {
      this.oldStores = oldStores;
      return this;
    }

    public Builder storesRef(List<KeyReference> storesRef) {
      this.storesRef = storesRef;
      return this;
    }

    public Builder oldStoresRef(List<KeyReference> oldStoresRef) {
      this.oldStoresRef = oldStoresRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
