package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class BusinessUnitUpdateAction {
  private AddBusinessUnitAddress addAddress;

  private AddBusinessUnitAssociate addAssociate;

  private AddBusinessUnitBillingAddressId addBillingAddressId;

  private AddBusinessUnitShippingAddressId addShippingAddressId;

  private AddBusinessUnitStore addStore;

  private ChangeBusinessUnitAddress changeAddress;

  private ChangeBusinessUnitAssociate changeAssociate;

  private ChangeBusinessUnitName changeName;

  private ChangeBusinessUnitParentUnit changeParentUnit;

  private ChangeBusinessUnitStatus changeStatus;

  private RemoveBusinessUnitAddress removeAddress;

  private RemoveBusinessUnitAssociate removeAssociate;

  private RemoveBusinessUnitBillingAddressId removeBillingAddressId;

  private RemoveBusinessUnitShippingAddressId removeShippingAddressId;

  private RemoveBusinessUnitStore removeStore;

  private SetBusinessUnitAddressCustomField setAddressCustomField;

  private SetBusinessUnitAddressCustomType setAddressCustomType;

  private SetBusinessUnitAssociates setAssociates;

  private SetBusinessUnitContactEmail setContactEmail;

  private SetBusinessUnitCustomField setCustomField;

  private SetBusinessUnitCustomType setCustomType;

  private SetBusinessUnitDefaultBillingAddress setDefaultBillingAddress;

  private SetBusinessUnitDefaultShippingAddress setDefaultShippingAddress;

  private SetBusinessUnitStores setStores;

  private SetBusinessUnitStoreMode setStoreMode;

  private ChangeBusinessUnitAssociateMode changeAssociateMode;

  private ChangeBusinessUnitApprovalRuleMode changeApprovalRuleMode;

  public BusinessUnitUpdateAction() {
  }

  public BusinessUnitUpdateAction(AddBusinessUnitAddress addAddress,
      AddBusinessUnitAssociate addAssociate, AddBusinessUnitBillingAddressId addBillingAddressId,
      AddBusinessUnitShippingAddressId addShippingAddressId, AddBusinessUnitStore addStore,
      ChangeBusinessUnitAddress changeAddress, ChangeBusinessUnitAssociate changeAssociate,
      ChangeBusinessUnitName changeName, ChangeBusinessUnitParentUnit changeParentUnit,
      ChangeBusinessUnitStatus changeStatus, RemoveBusinessUnitAddress removeAddress,
      RemoveBusinessUnitAssociate removeAssociate,
      RemoveBusinessUnitBillingAddressId removeBillingAddressId,
      RemoveBusinessUnitShippingAddressId removeShippingAddressId,
      RemoveBusinessUnitStore removeStore, SetBusinessUnitAddressCustomField setAddressCustomField,
      SetBusinessUnitAddressCustomType setAddressCustomType,
      SetBusinessUnitAssociates setAssociates, SetBusinessUnitContactEmail setContactEmail,
      SetBusinessUnitCustomField setCustomField, SetBusinessUnitCustomType setCustomType,
      SetBusinessUnitDefaultBillingAddress setDefaultBillingAddress,
      SetBusinessUnitDefaultShippingAddress setDefaultShippingAddress,
      SetBusinessUnitStores setStores, SetBusinessUnitStoreMode setStoreMode,
      ChangeBusinessUnitAssociateMode changeAssociateMode,
      ChangeBusinessUnitApprovalRuleMode changeApprovalRuleMode) {
    this.addAddress = addAddress;
    this.addAssociate = addAssociate;
    this.addBillingAddressId = addBillingAddressId;
    this.addShippingAddressId = addShippingAddressId;
    this.addStore = addStore;
    this.changeAddress = changeAddress;
    this.changeAssociate = changeAssociate;
    this.changeName = changeName;
    this.changeParentUnit = changeParentUnit;
    this.changeStatus = changeStatus;
    this.removeAddress = removeAddress;
    this.removeAssociate = removeAssociate;
    this.removeBillingAddressId = removeBillingAddressId;
    this.removeShippingAddressId = removeShippingAddressId;
    this.removeStore = removeStore;
    this.setAddressCustomField = setAddressCustomField;
    this.setAddressCustomType = setAddressCustomType;
    this.setAssociates = setAssociates;
    this.setContactEmail = setContactEmail;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDefaultBillingAddress = setDefaultBillingAddress;
    this.setDefaultShippingAddress = setDefaultShippingAddress;
    this.setStores = setStores;
    this.setStoreMode = setStoreMode;
    this.changeAssociateMode = changeAssociateMode;
    this.changeApprovalRuleMode = changeApprovalRuleMode;
  }

  public AddBusinessUnitAddress getAddAddress() {
    return addAddress;
  }

  public void setAddAddress(AddBusinessUnitAddress addAddress) {
    this.addAddress = addAddress;
  }

  public AddBusinessUnitAssociate getAddAssociate() {
    return addAssociate;
  }

  public void setAddAssociate(AddBusinessUnitAssociate addAssociate) {
    this.addAssociate = addAssociate;
  }

  public AddBusinessUnitBillingAddressId getAddBillingAddressId() {
    return addBillingAddressId;
  }

  public void setAddBillingAddressId(AddBusinessUnitBillingAddressId addBillingAddressId) {
    this.addBillingAddressId = addBillingAddressId;
  }

  public AddBusinessUnitShippingAddressId getAddShippingAddressId() {
    return addShippingAddressId;
  }

  public void setAddShippingAddressId(AddBusinessUnitShippingAddressId addShippingAddressId) {
    this.addShippingAddressId = addShippingAddressId;
  }

  public AddBusinessUnitStore getAddStore() {
    return addStore;
  }

  public void setAddStore(AddBusinessUnitStore addStore) {
    this.addStore = addStore;
  }

  public ChangeBusinessUnitAddress getChangeAddress() {
    return changeAddress;
  }

  public void setChangeAddress(ChangeBusinessUnitAddress changeAddress) {
    this.changeAddress = changeAddress;
  }

  public ChangeBusinessUnitAssociate getChangeAssociate() {
    return changeAssociate;
  }

  public void setChangeAssociate(ChangeBusinessUnitAssociate changeAssociate) {
    this.changeAssociate = changeAssociate;
  }

  public ChangeBusinessUnitName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeBusinessUnitName changeName) {
    this.changeName = changeName;
  }

  public ChangeBusinessUnitParentUnit getChangeParentUnit() {
    return changeParentUnit;
  }

  public void setChangeParentUnit(ChangeBusinessUnitParentUnit changeParentUnit) {
    this.changeParentUnit = changeParentUnit;
  }

  public ChangeBusinessUnitStatus getChangeStatus() {
    return changeStatus;
  }

  public void setChangeStatus(ChangeBusinessUnitStatus changeStatus) {
    this.changeStatus = changeStatus;
  }

  public RemoveBusinessUnitAddress getRemoveAddress() {
    return removeAddress;
  }

  public void setRemoveAddress(RemoveBusinessUnitAddress removeAddress) {
    this.removeAddress = removeAddress;
  }

  public RemoveBusinessUnitAssociate getRemoveAssociate() {
    return removeAssociate;
  }

  public void setRemoveAssociate(RemoveBusinessUnitAssociate removeAssociate) {
    this.removeAssociate = removeAssociate;
  }

  public RemoveBusinessUnitBillingAddressId getRemoveBillingAddressId() {
    return removeBillingAddressId;
  }

  public void setRemoveBillingAddressId(RemoveBusinessUnitBillingAddressId removeBillingAddressId) {
    this.removeBillingAddressId = removeBillingAddressId;
  }

  public RemoveBusinessUnitShippingAddressId getRemoveShippingAddressId() {
    return removeShippingAddressId;
  }

  public void setRemoveShippingAddressId(
      RemoveBusinessUnitShippingAddressId removeShippingAddressId) {
    this.removeShippingAddressId = removeShippingAddressId;
  }

  public RemoveBusinessUnitStore getRemoveStore() {
    return removeStore;
  }

  public void setRemoveStore(RemoveBusinessUnitStore removeStore) {
    this.removeStore = removeStore;
  }

  public SetBusinessUnitAddressCustomField getSetAddressCustomField() {
    return setAddressCustomField;
  }

  public void setSetAddressCustomField(SetBusinessUnitAddressCustomField setAddressCustomField) {
    this.setAddressCustomField = setAddressCustomField;
  }

  public SetBusinessUnitAddressCustomType getSetAddressCustomType() {
    return setAddressCustomType;
  }

  public void setSetAddressCustomType(SetBusinessUnitAddressCustomType setAddressCustomType) {
    this.setAddressCustomType = setAddressCustomType;
  }

  public SetBusinessUnitAssociates getSetAssociates() {
    return setAssociates;
  }

  public void setSetAssociates(SetBusinessUnitAssociates setAssociates) {
    this.setAssociates = setAssociates;
  }

  public SetBusinessUnitContactEmail getSetContactEmail() {
    return setContactEmail;
  }

  public void setSetContactEmail(SetBusinessUnitContactEmail setContactEmail) {
    this.setContactEmail = setContactEmail;
  }

  public SetBusinessUnitCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetBusinessUnitCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetBusinessUnitCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetBusinessUnitCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetBusinessUnitDefaultBillingAddress getSetDefaultBillingAddress() {
    return setDefaultBillingAddress;
  }

  public void setSetDefaultBillingAddress(
      SetBusinessUnitDefaultBillingAddress setDefaultBillingAddress) {
    this.setDefaultBillingAddress = setDefaultBillingAddress;
  }

  public SetBusinessUnitDefaultShippingAddress getSetDefaultShippingAddress() {
    return setDefaultShippingAddress;
  }

  public void setSetDefaultShippingAddress(
      SetBusinessUnitDefaultShippingAddress setDefaultShippingAddress) {
    this.setDefaultShippingAddress = setDefaultShippingAddress;
  }

  public SetBusinessUnitStores getSetStores() {
    return setStores;
  }

  public void setSetStores(SetBusinessUnitStores setStores) {
    this.setStores = setStores;
  }

  public SetBusinessUnitStoreMode getSetStoreMode() {
    return setStoreMode;
  }

  public void setSetStoreMode(SetBusinessUnitStoreMode setStoreMode) {
    this.setStoreMode = setStoreMode;
  }

  public ChangeBusinessUnitAssociateMode getChangeAssociateMode() {
    return changeAssociateMode;
  }

  public void setChangeAssociateMode(ChangeBusinessUnitAssociateMode changeAssociateMode) {
    this.changeAssociateMode = changeAssociateMode;
  }

  public ChangeBusinessUnitApprovalRuleMode getChangeApprovalRuleMode() {
    return changeApprovalRuleMode;
  }

  public void setChangeApprovalRuleMode(ChangeBusinessUnitApprovalRuleMode changeApprovalRuleMode) {
    this.changeApprovalRuleMode = changeApprovalRuleMode;
  }

  @Override
  public String toString() {
    return "BusinessUnitUpdateAction{addAddress='" + addAddress + "', addAssociate='" + addAssociate + "', addBillingAddressId='" + addBillingAddressId + "', addShippingAddressId='" + addShippingAddressId + "', addStore='" + addStore + "', changeAddress='" + changeAddress + "', changeAssociate='" + changeAssociate + "', changeName='" + changeName + "', changeParentUnit='" + changeParentUnit + "', changeStatus='" + changeStatus + "', removeAddress='" + removeAddress + "', removeAssociate='" + removeAssociate + "', removeBillingAddressId='" + removeBillingAddressId + "', removeShippingAddressId='" + removeShippingAddressId + "', removeStore='" + removeStore + "', setAddressCustomField='" + setAddressCustomField + "', setAddressCustomType='" + setAddressCustomType + "', setAssociates='" + setAssociates + "', setContactEmail='" + setContactEmail + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDefaultBillingAddress='" + setDefaultBillingAddress + "', setDefaultShippingAddress='" + setDefaultShippingAddress + "', setStores='" + setStores + "', setStoreMode='" + setStoreMode + "', changeAssociateMode='" + changeAssociateMode + "', changeApprovalRuleMode='" + changeApprovalRuleMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BusinessUnitUpdateAction that = (BusinessUnitUpdateAction) o;
    return Objects.equals(addAddress, that.addAddress) &&
        Objects.equals(addAssociate, that.addAssociate) &&
        Objects.equals(addBillingAddressId, that.addBillingAddressId) &&
        Objects.equals(addShippingAddressId, that.addShippingAddressId) &&
        Objects.equals(addStore, that.addStore) &&
        Objects.equals(changeAddress, that.changeAddress) &&
        Objects.equals(changeAssociate, that.changeAssociate) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeParentUnit, that.changeParentUnit) &&
        Objects.equals(changeStatus, that.changeStatus) &&
        Objects.equals(removeAddress, that.removeAddress) &&
        Objects.equals(removeAssociate, that.removeAssociate) &&
        Objects.equals(removeBillingAddressId, that.removeBillingAddressId) &&
        Objects.equals(removeShippingAddressId, that.removeShippingAddressId) &&
        Objects.equals(removeStore, that.removeStore) &&
        Objects.equals(setAddressCustomField, that.setAddressCustomField) &&
        Objects.equals(setAddressCustomType, that.setAddressCustomType) &&
        Objects.equals(setAssociates, that.setAssociates) &&
        Objects.equals(setContactEmail, that.setContactEmail) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDefaultBillingAddress, that.setDefaultBillingAddress) &&
        Objects.equals(setDefaultShippingAddress, that.setDefaultShippingAddress) &&
        Objects.equals(setStores, that.setStores) &&
        Objects.equals(setStoreMode, that.setStoreMode) &&
        Objects.equals(changeAssociateMode, that.changeAssociateMode) &&
        Objects.equals(changeApprovalRuleMode, that.changeApprovalRuleMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addAddress, addAssociate, addBillingAddressId, addShippingAddressId, addStore, changeAddress, changeAssociate, changeName, changeParentUnit, changeStatus, removeAddress, removeAssociate, removeBillingAddressId, removeShippingAddressId, removeStore, setAddressCustomField, setAddressCustomType, setAssociates, setContactEmail, setCustomField, setCustomType, setDefaultBillingAddress, setDefaultShippingAddress, setStores, setStoreMode, changeAssociateMode, changeApprovalRuleMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddBusinessUnitAddress addAddress;

    private AddBusinessUnitAssociate addAssociate;

    private AddBusinessUnitBillingAddressId addBillingAddressId;

    private AddBusinessUnitShippingAddressId addShippingAddressId;

    private AddBusinessUnitStore addStore;

    private ChangeBusinessUnitAddress changeAddress;

    private ChangeBusinessUnitAssociate changeAssociate;

    private ChangeBusinessUnitName changeName;

    private ChangeBusinessUnitParentUnit changeParentUnit;

    private ChangeBusinessUnitStatus changeStatus;

    private RemoveBusinessUnitAddress removeAddress;

    private RemoveBusinessUnitAssociate removeAssociate;

    private RemoveBusinessUnitBillingAddressId removeBillingAddressId;

    private RemoveBusinessUnitShippingAddressId removeShippingAddressId;

    private RemoveBusinessUnitStore removeStore;

    private SetBusinessUnitAddressCustomField setAddressCustomField;

    private SetBusinessUnitAddressCustomType setAddressCustomType;

    private SetBusinessUnitAssociates setAssociates;

    private SetBusinessUnitContactEmail setContactEmail;

    private SetBusinessUnitCustomField setCustomField;

    private SetBusinessUnitCustomType setCustomType;

    private SetBusinessUnitDefaultBillingAddress setDefaultBillingAddress;

    private SetBusinessUnitDefaultShippingAddress setDefaultShippingAddress;

    private SetBusinessUnitStores setStores;

    private SetBusinessUnitStoreMode setStoreMode;

    private ChangeBusinessUnitAssociateMode changeAssociateMode;

    private ChangeBusinessUnitApprovalRuleMode changeApprovalRuleMode;

    public BusinessUnitUpdateAction build() {
      BusinessUnitUpdateAction result = new BusinessUnitUpdateAction();
      result.addAddress = this.addAddress;
      result.addAssociate = this.addAssociate;
      result.addBillingAddressId = this.addBillingAddressId;
      result.addShippingAddressId = this.addShippingAddressId;
      result.addStore = this.addStore;
      result.changeAddress = this.changeAddress;
      result.changeAssociate = this.changeAssociate;
      result.changeName = this.changeName;
      result.changeParentUnit = this.changeParentUnit;
      result.changeStatus = this.changeStatus;
      result.removeAddress = this.removeAddress;
      result.removeAssociate = this.removeAssociate;
      result.removeBillingAddressId = this.removeBillingAddressId;
      result.removeShippingAddressId = this.removeShippingAddressId;
      result.removeStore = this.removeStore;
      result.setAddressCustomField = this.setAddressCustomField;
      result.setAddressCustomType = this.setAddressCustomType;
      result.setAssociates = this.setAssociates;
      result.setContactEmail = this.setContactEmail;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDefaultBillingAddress = this.setDefaultBillingAddress;
      result.setDefaultShippingAddress = this.setDefaultShippingAddress;
      result.setStores = this.setStores;
      result.setStoreMode = this.setStoreMode;
      result.changeAssociateMode = this.changeAssociateMode;
      result.changeApprovalRuleMode = this.changeApprovalRuleMode;
      return result;
    }

    public Builder addAddress(AddBusinessUnitAddress addAddress) {
      this.addAddress = addAddress;
      return this;
    }

    public Builder addAssociate(AddBusinessUnitAssociate addAssociate) {
      this.addAssociate = addAssociate;
      return this;
    }

    public Builder addBillingAddressId(AddBusinessUnitBillingAddressId addBillingAddressId) {
      this.addBillingAddressId = addBillingAddressId;
      return this;
    }

    public Builder addShippingAddressId(AddBusinessUnitShippingAddressId addShippingAddressId) {
      this.addShippingAddressId = addShippingAddressId;
      return this;
    }

    public Builder addStore(AddBusinessUnitStore addStore) {
      this.addStore = addStore;
      return this;
    }

    public Builder changeAddress(ChangeBusinessUnitAddress changeAddress) {
      this.changeAddress = changeAddress;
      return this;
    }

    public Builder changeAssociate(ChangeBusinessUnitAssociate changeAssociate) {
      this.changeAssociate = changeAssociate;
      return this;
    }

    public Builder changeName(ChangeBusinessUnitName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeParentUnit(ChangeBusinessUnitParentUnit changeParentUnit) {
      this.changeParentUnit = changeParentUnit;
      return this;
    }

    public Builder changeStatus(ChangeBusinessUnitStatus changeStatus) {
      this.changeStatus = changeStatus;
      return this;
    }

    public Builder removeAddress(RemoveBusinessUnitAddress removeAddress) {
      this.removeAddress = removeAddress;
      return this;
    }

    public Builder removeAssociate(RemoveBusinessUnitAssociate removeAssociate) {
      this.removeAssociate = removeAssociate;
      return this;
    }

    public Builder removeBillingAddressId(
        RemoveBusinessUnitBillingAddressId removeBillingAddressId) {
      this.removeBillingAddressId = removeBillingAddressId;
      return this;
    }

    public Builder removeShippingAddressId(
        RemoveBusinessUnitShippingAddressId removeShippingAddressId) {
      this.removeShippingAddressId = removeShippingAddressId;
      return this;
    }

    public Builder removeStore(RemoveBusinessUnitStore removeStore) {
      this.removeStore = removeStore;
      return this;
    }

    public Builder setAddressCustomField(SetBusinessUnitAddressCustomField setAddressCustomField) {
      this.setAddressCustomField = setAddressCustomField;
      return this;
    }

    public Builder setAddressCustomType(SetBusinessUnitAddressCustomType setAddressCustomType) {
      this.setAddressCustomType = setAddressCustomType;
      return this;
    }

    public Builder setAssociates(SetBusinessUnitAssociates setAssociates) {
      this.setAssociates = setAssociates;
      return this;
    }

    public Builder setContactEmail(SetBusinessUnitContactEmail setContactEmail) {
      this.setContactEmail = setContactEmail;
      return this;
    }

    public Builder setCustomField(SetBusinessUnitCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetBusinessUnitCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setDefaultBillingAddress(
        SetBusinessUnitDefaultBillingAddress setDefaultBillingAddress) {
      this.setDefaultBillingAddress = setDefaultBillingAddress;
      return this;
    }

    public Builder setDefaultShippingAddress(
        SetBusinessUnitDefaultShippingAddress setDefaultShippingAddress) {
      this.setDefaultShippingAddress = setDefaultShippingAddress;
      return this;
    }

    public Builder setStores(SetBusinessUnitStores setStores) {
      this.setStores = setStores;
      return this;
    }

    public Builder setStoreMode(SetBusinessUnitStoreMode setStoreMode) {
      this.setStoreMode = setStoreMode;
      return this;
    }

    public Builder changeAssociateMode(ChangeBusinessUnitAssociateMode changeAssociateMode) {
      this.changeAssociateMode = changeAssociateMode;
      return this;
    }

    public Builder changeApprovalRuleMode(
        ChangeBusinessUnitApprovalRuleMode changeApprovalRuleMode) {
      this.changeApprovalRuleMode = changeApprovalRuleMode;
      return this;
    }
  }
}
