package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CartCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private Money totalPrice;

  private Integer lineItemCount;

  private List<Reference> discountCodesRefs;

  private String type;

  public CartCreated() {
  }

  public CartCreated(Money totalPrice, Integer lineItemCount, List<Reference> discountCodesRefs,
      String type) {
    this.totalPrice = totalPrice;
    this.lineItemCount = lineItemCount;
    this.discountCodesRefs = discountCodesRefs;
    this.type = type;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  public Integer getLineItemCount() {
    return lineItemCount;
  }

  public void setLineItemCount(Integer lineItemCount) {
    this.lineItemCount = lineItemCount;
  }

  public List<Reference> getDiscountCodesRefs() {
    return discountCodesRefs;
  }

  public void setDiscountCodesRefs(List<Reference> discountCodesRefs) {
    this.discountCodesRefs = discountCodesRefs;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "CartCreated{totalPrice='" + totalPrice + "', lineItemCount='" + lineItemCount + "', discountCodesRefs='" + discountCodesRefs + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartCreated that = (CartCreated) o;
    return Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(lineItemCount, that.lineItemCount) &&
        Objects.equals(discountCodesRefs, that.discountCodesRefs) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalPrice, lineItemCount, discountCodesRefs, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Money totalPrice;

    private Integer lineItemCount;

    private List<Reference> discountCodesRefs;

    private String type;

    public CartCreated build() {
      CartCreated result = new CartCreated();
      result.totalPrice = this.totalPrice;
      result.lineItemCount = this.lineItemCount;
      result.discountCodesRefs = this.discountCodesRefs;
      result.type = this.type;
      return result;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder lineItemCount(Integer lineItemCount) {
      this.lineItemCount = lineItemCount;
      return this;
    }

    public Builder discountCodesRefs(List<Reference> discountCodesRefs) {
      this.discountCodesRefs = discountCodesRefs;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
