package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 *
 * Cart discounts are recalculated every time LineItems or CustomLineItems are added or removed from the Cart or an order is created from the cart.
 *
 * The number of active cart discounts that do not require a discount code (isActive=true and requiresDiscountCode=false) is limited to 100.
 *       
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class CartDiscount implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String cartPredicate;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private StackingMode stackingMode;

  private Boolean isActive;

  private Boolean requiresDiscountCode;

  private String sortOrder;

  private String key;

  private String name;

  private String description;

  private List<LocalizedString> nameAllLocales;

  private List<LocalizedString> descriptionAllLocales;

  private List<Reference> referenceRefs;

  private CustomFieldsType custom;

  private List<KeyReference> storesRef;

  private List<Store> stores;

  private CartDiscountValue value;

  private CartDiscountTarget target;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public CartDiscount() {
  }

  public CartDiscount(String cartPredicate, OffsetDateTime validFrom, OffsetDateTime validUntil,
      StackingMode stackingMode, Boolean isActive, Boolean requiresDiscountCode, String sortOrder,
      String key, String name, String description, List<LocalizedString> nameAllLocales,
      List<LocalizedString> descriptionAllLocales, List<Reference> referenceRefs,
      CustomFieldsType custom, List<KeyReference> storesRef, List<Store> stores,
      CartDiscountValue value, CartDiscountTarget target, String id, Long version,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.cartPredicate = cartPredicate;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.stackingMode = stackingMode;
    this.isActive = isActive;
    this.requiresDiscountCode = requiresDiscountCode;
    this.sortOrder = sortOrder;
    this.key = key;
    this.name = name;
    this.description = description;
    this.nameAllLocales = nameAllLocales;
    this.descriptionAllLocales = descriptionAllLocales;
    this.referenceRefs = referenceRefs;
    this.custom = custom;
    this.storesRef = storesRef;
    this.stores = stores;
    this.value = value;
    this.target = target;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getCartPredicate() {
    return cartPredicate;
  }

  public void setCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public StackingMode getStackingMode() {
    return stackingMode;
  }

  public void setStackingMode(StackingMode stackingMode) {
    this.stackingMode = stackingMode;
  }

  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public Boolean getRequiresDiscountCode() {
    return requiresDiscountCode;
  }

  public void setRequiresDiscountCode(Boolean requiresDiscountCode) {
    this.requiresDiscountCode = requiresDiscountCode;
  }

  public String getSortOrder() {
    return sortOrder;
  }

  public void setSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public List<Reference> getReferenceRefs() {
    return referenceRefs;
  }

  public void setReferenceRefs(List<Reference> referenceRefs) {
    this.referenceRefs = referenceRefs;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public List<KeyReference> getStoresRef() {
    return storesRef;
  }

  public void setStoresRef(List<KeyReference> storesRef) {
    this.storesRef = storesRef;
  }

  public List<Store> getStores() {
    return stores;
  }

  public void setStores(List<Store> stores) {
    this.stores = stores;
  }

  public CartDiscountValue getValue() {
    return value;
  }

  public void setValue(CartDiscountValue value) {
    this.value = value;
  }

  public CartDiscountTarget getTarget() {
    return target;
  }

  public void setTarget(CartDiscountTarget target) {
    this.target = target;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "CartDiscount{cartPredicate='" + cartPredicate + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', stackingMode='" + stackingMode + "', isActive='" + isActive + "', requiresDiscountCode='" + requiresDiscountCode + "', sortOrder='" + sortOrder + "', key='" + key + "', name='" + name + "', description='" + description + "', nameAllLocales='" + nameAllLocales + "', descriptionAllLocales='" + descriptionAllLocales + "', referenceRefs='" + referenceRefs + "', custom='" + custom + "', storesRef='" + storesRef + "', stores='" + stores + "', value='" + value + "', target='" + target + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscount that = (CartDiscount) o;
    return Objects.equals(cartPredicate, that.cartPredicate) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(stackingMode, that.stackingMode) &&
        Objects.equals(isActive, that.isActive) &&
        Objects.equals(requiresDiscountCode, that.requiresDiscountCode) &&
        Objects.equals(sortOrder, that.sortOrder) &&
        Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(referenceRefs, that.referenceRefs) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(storesRef, that.storesRef) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(value, that.value) &&
        Objects.equals(target, that.target) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cartPredicate, validFrom, validUntil, stackingMode, isActive, requiresDiscountCode, sortOrder, key, name, description, nameAllLocales, descriptionAllLocales, referenceRefs, custom, storesRef, stores, value, target, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String cartPredicate;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private StackingMode stackingMode;

    private Boolean isActive;

    private Boolean requiresDiscountCode;

    private String sortOrder;

    private String key;

    private String name;

    private String description;

    private List<LocalizedString> nameAllLocales;

    private List<LocalizedString> descriptionAllLocales;

    private List<Reference> referenceRefs;

    private CustomFieldsType custom;

    private List<KeyReference> storesRef;

    private List<Store> stores;

    private CartDiscountValue value;

    private CartDiscountTarget target;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public CartDiscount build() {
      CartDiscount result = new CartDiscount();
      result.cartPredicate = this.cartPredicate;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.stackingMode = this.stackingMode;
      result.isActive = this.isActive;
      result.requiresDiscountCode = this.requiresDiscountCode;
      result.sortOrder = this.sortOrder;
      result.key = this.key;
      result.name = this.name;
      result.description = this.description;
      result.nameAllLocales = this.nameAllLocales;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.referenceRefs = this.referenceRefs;
      result.custom = this.custom;
      result.storesRef = this.storesRef;
      result.stores = this.stores;
      result.value = this.value;
      result.target = this.target;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder cartPredicate(String cartPredicate) {
      this.cartPredicate = cartPredicate;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder stackingMode(StackingMode stackingMode) {
      this.stackingMode = stackingMode;
      return this;
    }

    public Builder isActive(Boolean isActive) {
      this.isActive = isActive;
      return this;
    }

    public Builder requiresDiscountCode(Boolean requiresDiscountCode) {
      this.requiresDiscountCode = requiresDiscountCode;
      return this;
    }

    public Builder sortOrder(String sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder referenceRefs(List<Reference> referenceRefs) {
      this.referenceRefs = referenceRefs;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder storesRef(List<KeyReference> storesRef) {
      this.storesRef = storesRef;
      return this;
    }

    public Builder stores(List<Store> stores) {
      this.stores = stores;
      return this;
    }

    public Builder value(CartDiscountValue value) {
      this.value = value;
      return this;
    }

    public Builder target(CartDiscountTarget target) {
      this.target = target;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
