package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Fields to access cartDiscounts. Includes direct access to a single cartDiscount and searching for cartDiscounts.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes(@JsonSubTypes.Type(value = InStore.class, name = "InStore"))
public interface CartDiscountQueryInterface {
  CartDiscount getCartDiscount();

  void setCartDiscount(CartDiscount cartDiscount);

  CartDiscountQueryResult getCartDiscounts();

  void setCartDiscounts(CartDiscountQueryResult cartDiscounts);
}
