package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CartDiscountTargetInput {
  private LineItemsTargetInput lineItems;

  private CustomLineItemsTargetInput customLineItems;

  private ShippingTargetInput shipping;

  private MultiBuyLineItemsTargetInput multiBuyLineItems;

  private MultiBuyCustomLineItemsTargetInput multiBuyCustomLineItems;

  private CartDiscountTotalPriceTargetInput totalPrice;

  private CartDiscountPatternTargetInput pattern;

  public CartDiscountTargetInput() {
  }

  public CartDiscountTargetInput(LineItemsTargetInput lineItems,
      CustomLineItemsTargetInput customLineItems, ShippingTargetInput shipping,
      MultiBuyLineItemsTargetInput multiBuyLineItems,
      MultiBuyCustomLineItemsTargetInput multiBuyCustomLineItems,
      CartDiscountTotalPriceTargetInput totalPrice, CartDiscountPatternTargetInput pattern) {
    this.lineItems = lineItems;
    this.customLineItems = customLineItems;
    this.shipping = shipping;
    this.multiBuyLineItems = multiBuyLineItems;
    this.multiBuyCustomLineItems = multiBuyCustomLineItems;
    this.totalPrice = totalPrice;
    this.pattern = pattern;
  }

  public LineItemsTargetInput getLineItems() {
    return lineItems;
  }

  public void setLineItems(LineItemsTargetInput lineItems) {
    this.lineItems = lineItems;
  }

  public CustomLineItemsTargetInput getCustomLineItems() {
    return customLineItems;
  }

  public void setCustomLineItems(CustomLineItemsTargetInput customLineItems) {
    this.customLineItems = customLineItems;
  }

  public ShippingTargetInput getShipping() {
    return shipping;
  }

  public void setShipping(ShippingTargetInput shipping) {
    this.shipping = shipping;
  }

  public MultiBuyLineItemsTargetInput getMultiBuyLineItems() {
    return multiBuyLineItems;
  }

  public void setMultiBuyLineItems(MultiBuyLineItemsTargetInput multiBuyLineItems) {
    this.multiBuyLineItems = multiBuyLineItems;
  }

  public MultiBuyCustomLineItemsTargetInput getMultiBuyCustomLineItems() {
    return multiBuyCustomLineItems;
  }

  public void setMultiBuyCustomLineItems(
      MultiBuyCustomLineItemsTargetInput multiBuyCustomLineItems) {
    this.multiBuyCustomLineItems = multiBuyCustomLineItems;
  }

  public CartDiscountTotalPriceTargetInput getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(CartDiscountTotalPriceTargetInput totalPrice) {
    this.totalPrice = totalPrice;
  }

  public CartDiscountPatternTargetInput getPattern() {
    return pattern;
  }

  public void setPattern(CartDiscountPatternTargetInput pattern) {
    this.pattern = pattern;
  }

  @Override
  public String toString() {
    return "CartDiscountTargetInput{lineItems='" + lineItems + "', customLineItems='" + customLineItems + "', shipping='" + shipping + "', multiBuyLineItems='" + multiBuyLineItems + "', multiBuyCustomLineItems='" + multiBuyCustomLineItems + "', totalPrice='" + totalPrice + "', pattern='" + pattern + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountTargetInput that = (CartDiscountTargetInput) o;
    return Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(customLineItems, that.customLineItems) &&
        Objects.equals(shipping, that.shipping) &&
        Objects.equals(multiBuyLineItems, that.multiBuyLineItems) &&
        Objects.equals(multiBuyCustomLineItems, that.multiBuyCustomLineItems) &&
        Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(pattern, that.pattern);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItems, customLineItems, shipping, multiBuyLineItems, multiBuyCustomLineItems, totalPrice, pattern);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private LineItemsTargetInput lineItems;

    private CustomLineItemsTargetInput customLineItems;

    private ShippingTargetInput shipping;

    private MultiBuyLineItemsTargetInput multiBuyLineItems;

    private MultiBuyCustomLineItemsTargetInput multiBuyCustomLineItems;

    private CartDiscountTotalPriceTargetInput totalPrice;

    private CartDiscountPatternTargetInput pattern;

    public CartDiscountTargetInput build() {
      CartDiscountTargetInput result = new CartDiscountTargetInput();
      result.lineItems = this.lineItems;
      result.customLineItems = this.customLineItems;
      result.shipping = this.shipping;
      result.multiBuyLineItems = this.multiBuyLineItems;
      result.multiBuyCustomLineItems = this.multiBuyCustomLineItems;
      result.totalPrice = this.totalPrice;
      result.pattern = this.pattern;
      return result;
    }

    public Builder lineItems(LineItemsTargetInput lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder customLineItems(CustomLineItemsTargetInput customLineItems) {
      this.customLineItems = customLineItems;
      return this;
    }

    public Builder shipping(ShippingTargetInput shipping) {
      this.shipping = shipping;
      return this;
    }

    public Builder multiBuyLineItems(MultiBuyLineItemsTargetInput multiBuyLineItems) {
      this.multiBuyLineItems = multiBuyLineItems;
      return this;
    }

    public Builder multiBuyCustomLineItems(
        MultiBuyCustomLineItemsTargetInput multiBuyCustomLineItems) {
      this.multiBuyCustomLineItems = multiBuyCustomLineItems;
      return this;
    }

    public Builder totalPrice(CartDiscountTotalPriceTargetInput totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder pattern(CartDiscountPatternTargetInput pattern) {
      this.pattern = pattern;
      return this;
    }
  }
}
