package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CartDiscountUpdateAction {
  private SetCartDiscountStores setStores;

  private AddCartDiscountStore addStore;

  private RemoveCartDiscountStore removeStore;

  private ChangeCartDiscountCartPredicate changeCartPredicate;

  private ChangeCartDiscountIsActive changeIsActive;

  private ChangeCartDiscountName changeName;

  private ChangeCartDiscountRequiresDiscountCode changeRequiresDiscountCode;

  private ChangeCartDiscountSortOrder changeSortOrder;

  private ChangeCartDiscountStackingMode changeStackingMode;

  private ChangeCartDiscountTarget changeTarget;

  private ChangeCartDiscountValue changeValue;

  private SetCartDiscountCustomField setCustomField;

  private SetCartDiscountCustomType setCustomType;

  private SetCartDiscountDescription setDescription;

  private SetCartDiscountKey setKey;

  private SetCartDiscountValidFrom setValidFrom;

  private SetCartDiscountValidFromAndUntil setValidFromAndUntil;

  private SetCartDiscountValidUntil setValidUntil;

  public CartDiscountUpdateAction() {
  }

  public CartDiscountUpdateAction(SetCartDiscountStores setStores, AddCartDiscountStore addStore,
      RemoveCartDiscountStore removeStore, ChangeCartDiscountCartPredicate changeCartPredicate,
      ChangeCartDiscountIsActive changeIsActive, ChangeCartDiscountName changeName,
      ChangeCartDiscountRequiresDiscountCode changeRequiresDiscountCode,
      ChangeCartDiscountSortOrder changeSortOrder,
      ChangeCartDiscountStackingMode changeStackingMode, ChangeCartDiscountTarget changeTarget,
      ChangeCartDiscountValue changeValue, SetCartDiscountCustomField setCustomField,
      SetCartDiscountCustomType setCustomType, SetCartDiscountDescription setDescription,
      SetCartDiscountKey setKey, SetCartDiscountValidFrom setValidFrom,
      SetCartDiscountValidFromAndUntil setValidFromAndUntil,
      SetCartDiscountValidUntil setValidUntil) {
    this.setStores = setStores;
    this.addStore = addStore;
    this.removeStore = removeStore;
    this.changeCartPredicate = changeCartPredicate;
    this.changeIsActive = changeIsActive;
    this.changeName = changeName;
    this.changeRequiresDiscountCode = changeRequiresDiscountCode;
    this.changeSortOrder = changeSortOrder;
    this.changeStackingMode = changeStackingMode;
    this.changeTarget = changeTarget;
    this.changeValue = changeValue;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDescription = setDescription;
    this.setKey = setKey;
    this.setValidFrom = setValidFrom;
    this.setValidFromAndUntil = setValidFromAndUntil;
    this.setValidUntil = setValidUntil;
  }

  public SetCartDiscountStores getSetStores() {
    return setStores;
  }

  public void setSetStores(SetCartDiscountStores setStores) {
    this.setStores = setStores;
  }

  public AddCartDiscountStore getAddStore() {
    return addStore;
  }

  public void setAddStore(AddCartDiscountStore addStore) {
    this.addStore = addStore;
  }

  public RemoveCartDiscountStore getRemoveStore() {
    return removeStore;
  }

  public void setRemoveStore(RemoveCartDiscountStore removeStore) {
    this.removeStore = removeStore;
  }

  public ChangeCartDiscountCartPredicate getChangeCartPredicate() {
    return changeCartPredicate;
  }

  public void setChangeCartPredicate(ChangeCartDiscountCartPredicate changeCartPredicate) {
    this.changeCartPredicate = changeCartPredicate;
  }

  public ChangeCartDiscountIsActive getChangeIsActive() {
    return changeIsActive;
  }

  public void setChangeIsActive(ChangeCartDiscountIsActive changeIsActive) {
    this.changeIsActive = changeIsActive;
  }

  public ChangeCartDiscountName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeCartDiscountName changeName) {
    this.changeName = changeName;
  }

  public ChangeCartDiscountRequiresDiscountCode getChangeRequiresDiscountCode() {
    return changeRequiresDiscountCode;
  }

  public void setChangeRequiresDiscountCode(
      ChangeCartDiscountRequiresDiscountCode changeRequiresDiscountCode) {
    this.changeRequiresDiscountCode = changeRequiresDiscountCode;
  }

  public ChangeCartDiscountSortOrder getChangeSortOrder() {
    return changeSortOrder;
  }

  public void setChangeSortOrder(ChangeCartDiscountSortOrder changeSortOrder) {
    this.changeSortOrder = changeSortOrder;
  }

  public ChangeCartDiscountStackingMode getChangeStackingMode() {
    return changeStackingMode;
  }

  public void setChangeStackingMode(ChangeCartDiscountStackingMode changeStackingMode) {
    this.changeStackingMode = changeStackingMode;
  }

  public ChangeCartDiscountTarget getChangeTarget() {
    return changeTarget;
  }

  public void setChangeTarget(ChangeCartDiscountTarget changeTarget) {
    this.changeTarget = changeTarget;
  }

  public ChangeCartDiscountValue getChangeValue() {
    return changeValue;
  }

  public void setChangeValue(ChangeCartDiscountValue changeValue) {
    this.changeValue = changeValue;
  }

  public SetCartDiscountCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetCartDiscountCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetCartDiscountCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetCartDiscountCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetCartDiscountDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetCartDiscountDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetCartDiscountKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetCartDiscountKey setKey) {
    this.setKey = setKey;
  }

  public SetCartDiscountValidFrom getSetValidFrom() {
    return setValidFrom;
  }

  public void setSetValidFrom(SetCartDiscountValidFrom setValidFrom) {
    this.setValidFrom = setValidFrom;
  }

  public SetCartDiscountValidFromAndUntil getSetValidFromAndUntil() {
    return setValidFromAndUntil;
  }

  public void setSetValidFromAndUntil(SetCartDiscountValidFromAndUntil setValidFromAndUntil) {
    this.setValidFromAndUntil = setValidFromAndUntil;
  }

  public SetCartDiscountValidUntil getSetValidUntil() {
    return setValidUntil;
  }

  public void setSetValidUntil(SetCartDiscountValidUntil setValidUntil) {
    this.setValidUntil = setValidUntil;
  }

  @Override
  public String toString() {
    return "CartDiscountUpdateAction{setStores='" + setStores + "', addStore='" + addStore + "', removeStore='" + removeStore + "', changeCartPredicate='" + changeCartPredicate + "', changeIsActive='" + changeIsActive + "', changeName='" + changeName + "', changeRequiresDiscountCode='" + changeRequiresDiscountCode + "', changeSortOrder='" + changeSortOrder + "', changeStackingMode='" + changeStackingMode + "', changeTarget='" + changeTarget + "', changeValue='" + changeValue + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDescription='" + setDescription + "', setKey='" + setKey + "', setValidFrom='" + setValidFrom + "', setValidFromAndUntil='" + setValidFromAndUntil + "', setValidUntil='" + setValidUntil + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDiscountUpdateAction that = (CartDiscountUpdateAction) o;
    return Objects.equals(setStores, that.setStores) &&
        Objects.equals(addStore, that.addStore) &&
        Objects.equals(removeStore, that.removeStore) &&
        Objects.equals(changeCartPredicate, that.changeCartPredicate) &&
        Objects.equals(changeIsActive, that.changeIsActive) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeRequiresDiscountCode, that.changeRequiresDiscountCode) &&
        Objects.equals(changeSortOrder, that.changeSortOrder) &&
        Objects.equals(changeStackingMode, that.changeStackingMode) &&
        Objects.equals(changeTarget, that.changeTarget) &&
        Objects.equals(changeValue, that.changeValue) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setValidFrom, that.setValidFrom) &&
        Objects.equals(setValidFromAndUntil, that.setValidFromAndUntil) &&
        Objects.equals(setValidUntil, that.setValidUntil);
  }

  @Override
  public int hashCode() {
    return Objects.hash(setStores, addStore, removeStore, changeCartPredicate, changeIsActive, changeName, changeRequiresDiscountCode, changeSortOrder, changeStackingMode, changeTarget, changeValue, setCustomField, setCustomType, setDescription, setKey, setValidFrom, setValidFromAndUntil, setValidUntil);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private SetCartDiscountStores setStores;

    private AddCartDiscountStore addStore;

    private RemoveCartDiscountStore removeStore;

    private ChangeCartDiscountCartPredicate changeCartPredicate;

    private ChangeCartDiscountIsActive changeIsActive;

    private ChangeCartDiscountName changeName;

    private ChangeCartDiscountRequiresDiscountCode changeRequiresDiscountCode;

    private ChangeCartDiscountSortOrder changeSortOrder;

    private ChangeCartDiscountStackingMode changeStackingMode;

    private ChangeCartDiscountTarget changeTarget;

    private ChangeCartDiscountValue changeValue;

    private SetCartDiscountCustomField setCustomField;

    private SetCartDiscountCustomType setCustomType;

    private SetCartDiscountDescription setDescription;

    private SetCartDiscountKey setKey;

    private SetCartDiscountValidFrom setValidFrom;

    private SetCartDiscountValidFromAndUntil setValidFromAndUntil;

    private SetCartDiscountValidUntil setValidUntil;

    public CartDiscountUpdateAction build() {
      CartDiscountUpdateAction result = new CartDiscountUpdateAction();
      result.setStores = this.setStores;
      result.addStore = this.addStore;
      result.removeStore = this.removeStore;
      result.changeCartPredicate = this.changeCartPredicate;
      result.changeIsActive = this.changeIsActive;
      result.changeName = this.changeName;
      result.changeRequiresDiscountCode = this.changeRequiresDiscountCode;
      result.changeSortOrder = this.changeSortOrder;
      result.changeStackingMode = this.changeStackingMode;
      result.changeTarget = this.changeTarget;
      result.changeValue = this.changeValue;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      result.setValidFrom = this.setValidFrom;
      result.setValidFromAndUntil = this.setValidFromAndUntil;
      result.setValidUntil = this.setValidUntil;
      return result;
    }

    public Builder setStores(SetCartDiscountStores setStores) {
      this.setStores = setStores;
      return this;
    }

    public Builder addStore(AddCartDiscountStore addStore) {
      this.addStore = addStore;
      return this;
    }

    public Builder removeStore(RemoveCartDiscountStore removeStore) {
      this.removeStore = removeStore;
      return this;
    }

    public Builder changeCartPredicate(ChangeCartDiscountCartPredicate changeCartPredicate) {
      this.changeCartPredicate = changeCartPredicate;
      return this;
    }

    public Builder changeIsActive(ChangeCartDiscountIsActive changeIsActive) {
      this.changeIsActive = changeIsActive;
      return this;
    }

    public Builder changeName(ChangeCartDiscountName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeRequiresDiscountCode(
        ChangeCartDiscountRequiresDiscountCode changeRequiresDiscountCode) {
      this.changeRequiresDiscountCode = changeRequiresDiscountCode;
      return this;
    }

    public Builder changeSortOrder(ChangeCartDiscountSortOrder changeSortOrder) {
      this.changeSortOrder = changeSortOrder;
      return this;
    }

    public Builder changeStackingMode(ChangeCartDiscountStackingMode changeStackingMode) {
      this.changeStackingMode = changeStackingMode;
      return this;
    }

    public Builder changeTarget(ChangeCartDiscountTarget changeTarget) {
      this.changeTarget = changeTarget;
      return this;
    }

    public Builder changeValue(ChangeCartDiscountValue changeValue) {
      this.changeValue = changeValue;
      return this;
    }

    public Builder setCustomField(SetCartDiscountCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetCartDiscountCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setDescription(SetCartDiscountDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetCartDiscountKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setValidFrom(SetCartDiscountValidFrom setValidFrom) {
      this.setValidFrom = setValidFrom;
      return this;
    }

    public Builder setValidFromAndUntil(SetCartDiscountValidFromAndUntil setValidFromAndUntil) {
      this.setValidFromAndUntil = setValidFromAndUntil;
      return this;
    }

    public Builder setValidUntil(SetCartDiscountValidUntil setValidUntil) {
      this.setValidUntil = setValidUntil;
      return this;
    }
  }
}
