package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AbsoluteCartDiscountValue.class, name = "AbsoluteCartDiscountValue"),
    @JsonSubTypes.Type(value = AbsoluteDiscountValue.class, name = "AbsoluteDiscountValue"),
    @JsonSubTypes.Type(value = FixedPriceCartDiscountValue.class, name = "FixedPriceCartDiscountValue"),
    @JsonSubTypes.Type(value = FixedPriceDiscountValue.class, name = "FixedPriceDiscountValue"),
    @JsonSubTypes.Type(value = GiftLineItemValue.class, name = "GiftLineItemValue"),
    @JsonSubTypes.Type(value = RelativeDiscountValue.class, name = "RelativeDiscountValue")
})
public interface CartDiscountValue {
  String getType();

  void setType(String type);
}
