package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

public class CartDraft {
  private Currency currency;

  private String country;

  private InventoryMode inventoryMode = InventoryMode.None;

  private CustomFieldsDraft custom;

  private String customerEmail;

  private AddressInput shippingAddress;

  private AddressInput billingAddress;

  private ResourceIdentifierInput shippingMethod;

  private TaxMode taxMode = TaxMode.Platform;

  private String locale;

  private Integer deleteDaysAfterLastModification;

  private List<AddressInput> itemShippingAddresses = Collections.emptyList();

  private List<String> discountCodes = Collections.emptyList();

  private ResourceIdentifierInput store;

  private ResourceIdentifierInput businessUnit;

  private ShippingMode shippingMode = ShippingMode.Single;

  private List<CustomShippingDraft> customShipping = Collections.emptyList();

  private List<ShippingDraft> shipping = Collections.emptyList();

  private String key;

  private List<LineItemDraft> lineItems = Collections.emptyList();

  private List<CustomLineItemDraft> customLineItems = Collections.emptyList();

  private String customerId;

  private ExternalTaxRateDraft externalTaxRateForShippingMethod;

  private String anonymousId;

  private RoundingMode taxRoundingMode = RoundingMode.HalfEven;

  private TaxCalculationMode taxCalculationMode = TaxCalculationMode.LineItemLevel;

  private ResourceIdentifierInput customerGroup;

  private ShippingRateInputDraft shippingRateInput;

  private CartOrigin origin = CartOrigin.Customer;

  public CartDraft() {
  }

  public CartDraft(Currency currency, String country, InventoryMode inventoryMode,
      CustomFieldsDraft custom, String customerEmail, AddressInput shippingAddress,
      AddressInput billingAddress, ResourceIdentifierInput shippingMethod, TaxMode taxMode,
      String locale, Integer deleteDaysAfterLastModification,
      List<AddressInput> itemShippingAddresses, List<String> discountCodes,
      ResourceIdentifierInput store, ResourceIdentifierInput businessUnit,
      ShippingMode shippingMode, List<CustomShippingDraft> customShipping,
      List<ShippingDraft> shipping, String key, List<LineItemDraft> lineItems,
      List<CustomLineItemDraft> customLineItems, String customerId,
      ExternalTaxRateDraft externalTaxRateForShippingMethod, String anonymousId,
      RoundingMode taxRoundingMode, TaxCalculationMode taxCalculationMode,
      ResourceIdentifierInput customerGroup, ShippingRateInputDraft shippingRateInput,
      CartOrigin origin) {
    this.currency = currency;
    this.country = country;
    this.inventoryMode = inventoryMode;
    this.custom = custom;
    this.customerEmail = customerEmail;
    this.shippingAddress = shippingAddress;
    this.billingAddress = billingAddress;
    this.shippingMethod = shippingMethod;
    this.taxMode = taxMode;
    this.locale = locale;
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
    this.itemShippingAddresses = itemShippingAddresses;
    this.discountCodes = discountCodes;
    this.store = store;
    this.businessUnit = businessUnit;
    this.shippingMode = shippingMode;
    this.customShipping = customShipping;
    this.shipping = shipping;
    this.key = key;
    this.lineItems = lineItems;
    this.customLineItems = customLineItems;
    this.customerId = customerId;
    this.externalTaxRateForShippingMethod = externalTaxRateForShippingMethod;
    this.anonymousId = anonymousId;
    this.taxRoundingMode = taxRoundingMode;
    this.taxCalculationMode = taxCalculationMode;
    this.customerGroup = customerGroup;
    this.shippingRateInput = shippingRateInput;
    this.origin = origin;
  }

  public Currency getCurrency() {
    return currency;
  }

  public void setCurrency(Currency currency) {
    this.currency = currency;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getCustomerEmail() {
    return customerEmail;
  }

  public void setCustomerEmail(String customerEmail) {
    this.customerEmail = customerEmail;
  }

  public AddressInput getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(AddressInput shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public AddressInput getBillingAddress() {
    return billingAddress;
  }

  public void setBillingAddress(AddressInput billingAddress) {
    this.billingAddress = billingAddress;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public TaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public Integer getDeleteDaysAfterLastModification() {
    return deleteDaysAfterLastModification;
  }

  public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  public List<AddressInput> getItemShippingAddresses() {
    return itemShippingAddresses;
  }

  public void setItemShippingAddresses(List<AddressInput> itemShippingAddresses) {
    this.itemShippingAddresses = itemShippingAddresses;
  }

  public List<String> getDiscountCodes() {
    return discountCodes;
  }

  public void setDiscountCodes(List<String> discountCodes) {
    this.discountCodes = discountCodes;
  }

  public ResourceIdentifierInput getStore() {
    return store;
  }

  public void setStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  public ResourceIdentifierInput getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  public ShippingMode getShippingMode() {
    return shippingMode;
  }

  public void setShippingMode(ShippingMode shippingMode) {
    this.shippingMode = shippingMode;
  }

  public List<CustomShippingDraft> getCustomShipping() {
    return customShipping;
  }

  public void setCustomShipping(List<CustomShippingDraft> customShipping) {
    this.customShipping = customShipping;
  }

  public List<ShippingDraft> getShipping() {
    return shipping;
  }

  public void setShipping(List<ShippingDraft> shipping) {
    this.shipping = shipping;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LineItemDraft> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<LineItemDraft> lineItems) {
    this.lineItems = lineItems;
  }

  public List<CustomLineItemDraft> getCustomLineItems() {
    return customLineItems;
  }

  public void setCustomLineItems(List<CustomLineItemDraft> customLineItems) {
    this.customLineItems = customLineItems;
  }

  public String getCustomerId() {
    return customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }

  public ExternalTaxRateDraft getExternalTaxRateForShippingMethod() {
    return externalTaxRateForShippingMethod;
  }

  public void setExternalTaxRateForShippingMethod(
      ExternalTaxRateDraft externalTaxRateForShippingMethod) {
    this.externalTaxRateForShippingMethod = externalTaxRateForShippingMethod;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public RoundingMode getTaxRoundingMode() {
    return taxRoundingMode;
  }

  public void setTaxRoundingMode(RoundingMode taxRoundingMode) {
    this.taxRoundingMode = taxRoundingMode;
  }

  public TaxCalculationMode getTaxCalculationMode() {
    return taxCalculationMode;
  }

  public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  public ResourceIdentifierInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ResourceIdentifierInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  public ShippingRateInputDraft getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInputDraft shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public CartOrigin getOrigin() {
    return origin;
  }

  public void setOrigin(CartOrigin origin) {
    this.origin = origin;
  }

  @Override
  public String toString() {
    return "CartDraft{currency='" + currency + "', country='" + country + "', inventoryMode='" + inventoryMode + "', custom='" + custom + "', customerEmail='" + customerEmail + "', shippingAddress='" + shippingAddress + "', billingAddress='" + billingAddress + "', shippingMethod='" + shippingMethod + "', taxMode='" + taxMode + "', locale='" + locale + "', deleteDaysAfterLastModification='" + deleteDaysAfterLastModification + "', itemShippingAddresses='" + itemShippingAddresses + "', discountCodes='" + discountCodes + "', store='" + store + "', businessUnit='" + businessUnit + "', shippingMode='" + shippingMode + "', customShipping='" + customShipping + "', shipping='" + shipping + "', key='" + key + "', lineItems='" + lineItems + "', customLineItems='" + customLineItems + "', customerId='" + customerId + "', externalTaxRateForShippingMethod='" + externalTaxRateForShippingMethod + "', anonymousId='" + anonymousId + "', taxRoundingMode='" + taxRoundingMode + "', taxCalculationMode='" + taxCalculationMode + "', customerGroup='" + customerGroup + "', shippingRateInput='" + shippingRateInput + "', origin='" + origin + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartDraft that = (CartDraft) o;
    return Objects.equals(currency, that.currency) &&
        Objects.equals(country, that.country) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(customerEmail, that.customerEmail) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(billingAddress, that.billingAddress) &&
        Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(taxMode, that.taxMode) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(deleteDaysAfterLastModification, that.deleteDaysAfterLastModification) &&
        Objects.equals(itemShippingAddresses, that.itemShippingAddresses) &&
        Objects.equals(discountCodes, that.discountCodes) &&
        Objects.equals(store, that.store) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(shippingMode, that.shippingMode) &&
        Objects.equals(customShipping, that.customShipping) &&
        Objects.equals(shipping, that.shipping) &&
        Objects.equals(key, that.key) &&
        Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(customLineItems, that.customLineItems) &&
        Objects.equals(customerId, that.customerId) &&
        Objects.equals(externalTaxRateForShippingMethod, that.externalTaxRateForShippingMethod) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(taxRoundingMode, that.taxRoundingMode) &&
        Objects.equals(taxCalculationMode, that.taxCalculationMode) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(origin, that.origin);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, country, inventoryMode, custom, customerEmail, shippingAddress, billingAddress, shippingMethod, taxMode, locale, deleteDaysAfterLastModification, itemShippingAddresses, discountCodes, store, businessUnit, shippingMode, customShipping, shipping, key, lineItems, customLineItems, customerId, externalTaxRateForShippingMethod, anonymousId, taxRoundingMode, taxCalculationMode, customerGroup, shippingRateInput, origin);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Currency currency;

    private String country;

    private InventoryMode inventoryMode = InventoryMode.None;

    private CustomFieldsDraft custom;

    private String customerEmail;

    private AddressInput shippingAddress;

    private AddressInput billingAddress;

    private ResourceIdentifierInput shippingMethod;

    private TaxMode taxMode = TaxMode.Platform;

    private String locale;

    private Integer deleteDaysAfterLastModification;

    private List<AddressInput> itemShippingAddresses = Collections.emptyList();

    private List<String> discountCodes = Collections.emptyList();

    private ResourceIdentifierInput store;

    private ResourceIdentifierInput businessUnit;

    private ShippingMode shippingMode = ShippingMode.Single;

    private List<CustomShippingDraft> customShipping = Collections.emptyList();

    private List<ShippingDraft> shipping = Collections.emptyList();

    private String key;

    private List<LineItemDraft> lineItems = Collections.emptyList();

    private List<CustomLineItemDraft> customLineItems = Collections.emptyList();

    private String customerId;

    private ExternalTaxRateDraft externalTaxRateForShippingMethod;

    private String anonymousId;

    private RoundingMode taxRoundingMode = RoundingMode.HalfEven;

    private TaxCalculationMode taxCalculationMode = TaxCalculationMode.LineItemLevel;

    private ResourceIdentifierInput customerGroup;

    private ShippingRateInputDraft shippingRateInput;

    private CartOrigin origin = CartOrigin.Customer;

    public CartDraft build() {
      CartDraft result = new CartDraft();
      result.currency = this.currency;
      result.country = this.country;
      result.inventoryMode = this.inventoryMode;
      result.custom = this.custom;
      result.customerEmail = this.customerEmail;
      result.shippingAddress = this.shippingAddress;
      result.billingAddress = this.billingAddress;
      result.shippingMethod = this.shippingMethod;
      result.taxMode = this.taxMode;
      result.locale = this.locale;
      result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
      result.itemShippingAddresses = this.itemShippingAddresses;
      result.discountCodes = this.discountCodes;
      result.store = this.store;
      result.businessUnit = this.businessUnit;
      result.shippingMode = this.shippingMode;
      result.customShipping = this.customShipping;
      result.shipping = this.shipping;
      result.key = this.key;
      result.lineItems = this.lineItems;
      result.customLineItems = this.customLineItems;
      result.customerId = this.customerId;
      result.externalTaxRateForShippingMethod = this.externalTaxRateForShippingMethod;
      result.anonymousId = this.anonymousId;
      result.taxRoundingMode = this.taxRoundingMode;
      result.taxCalculationMode = this.taxCalculationMode;
      result.customerGroup = this.customerGroup;
      result.shippingRateInput = this.shippingRateInput;
      result.origin = this.origin;
      return result;
    }

    public Builder currency(Currency currency) {
      this.currency = currency;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder customerEmail(String customerEmail) {
      this.customerEmail = customerEmail;
      return this;
    }

    public Builder shippingAddress(AddressInput shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder billingAddress(AddressInput billingAddress) {
      this.billingAddress = billingAddress;
      return this;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder taxMode(TaxMode taxMode) {
      this.taxMode = taxMode;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
      this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
      return this;
    }

    public Builder itemShippingAddresses(List<AddressInput> itemShippingAddresses) {
      this.itemShippingAddresses = itemShippingAddresses;
      return this;
    }

    public Builder discountCodes(List<String> discountCodes) {
      this.discountCodes = discountCodes;
      return this;
    }

    public Builder store(ResourceIdentifierInput store) {
      this.store = store;
      return this;
    }

    public Builder businessUnit(ResourceIdentifierInput businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder shippingMode(ShippingMode shippingMode) {
      this.shippingMode = shippingMode;
      return this;
    }

    public Builder customShipping(List<CustomShippingDraft> customShipping) {
      this.customShipping = customShipping;
      return this;
    }

    public Builder shipping(List<ShippingDraft> shipping) {
      this.shipping = shipping;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder lineItems(List<LineItemDraft> lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder customLineItems(List<CustomLineItemDraft> customLineItems) {
      this.customLineItems = customLineItems;
      return this;
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      return this;
    }

    public Builder externalTaxRateForShippingMethod(
        ExternalTaxRateDraft externalTaxRateForShippingMethod) {
      this.externalTaxRateForShippingMethod = externalTaxRateForShippingMethod;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder taxRoundingMode(RoundingMode taxRoundingMode) {
      this.taxRoundingMode = taxRoundingMode;
      return this;
    }

    public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
      this.taxCalculationMode = taxCalculationMode;
      return this;
    }

    public Builder customerGroup(ResourceIdentifierInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInputDraft shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder origin(CartOrigin origin) {
      this.origin = origin;
      return this;
    }
  }
}
