package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CartLimitsProjection {
  private CartLimitWithCurrent total;

  public CartLimitsProjection() {
  }

  public CartLimitsProjection(CartLimitWithCurrent total) {
    this.total = total;
  }

  public CartLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(CartLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "CartLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CartLimitsProjection that = (CartLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartLimitWithCurrent total;

    public CartLimitsProjection build() {
      CartLimitsProjection result = new CartLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(CartLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
