package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Fields to access carts. Includes direct access to a single cart and searching for carts.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AsAssociate.class, name = "AsAssociate"),
    @JsonSubTypes.Type(value = InStore.class, name = "InStore"),
    @JsonSubTypes.Type(value = InStoreMe.class, name = "InStoreMe"),
    @JsonSubTypes.Type(value = Me.class, name = "Me")
})
public interface CartQueryInterface {
  Cart getCart();

  void setCart(Cart cart);

  CartQueryResult getCarts();

  void setCarts(CartQueryResult carts);
}
