package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CategoryOrderHint {
  private String categoryId;

  private String orderHint;

  public CategoryOrderHint() {
  }

  public CategoryOrderHint(String categoryId, String orderHint) {
    this.categoryId = categoryId;
    this.orderHint = orderHint;
  }

  public String getCategoryId() {
    return categoryId;
  }

  public void setCategoryId(String categoryId) {
    this.categoryId = categoryId;
  }

  public String getOrderHint() {
    return orderHint;
  }

  public void setOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  @Override
  public String toString() {
    return "CategoryOrderHint{categoryId='" + categoryId + "', orderHint='" + orderHint + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CategoryOrderHint that = (CategoryOrderHint) o;
    return Objects.equals(categoryId, that.categoryId) &&
        Objects.equals(orderHint, that.orderHint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(categoryId, orderHint);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String categoryId;

    private String orderHint;

    public CategoryOrderHint build() {
      CategoryOrderHint result = new CategoryOrderHint();
      result.categoryId = this.categoryId;
      result.orderHint = this.orderHint;
      return result;
    }

    public Builder categoryId(String categoryId) {
      this.categoryId = categoryId;
      return this;
    }

    public Builder orderHint(String orderHint) {
      this.orderHint = orderHint;
      return this;
    }
  }
}
