package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CategoryOrderHintInput {
  private String uuid;

  private String orderHint;

  public CategoryOrderHintInput() {
  }

  public CategoryOrderHintInput(String uuid, String orderHint) {
    this.uuid = uuid;
    this.orderHint = orderHint;
  }

  public String getUuid() {
    return uuid;
  }

  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  public String getOrderHint() {
    return orderHint;
  }

  public void setOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  @Override
  public String toString() {
    return "CategoryOrderHintInput{uuid='" + uuid + "', orderHint='" + orderHint + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CategoryOrderHintInput that = (CategoryOrderHintInput) o;
    return Objects.equals(uuid, that.uuid) &&
        Objects.equals(orderHint, that.orderHint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uuid, orderHint);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String uuid;

    private String orderHint;

    public CategoryOrderHintInput build() {
      CategoryOrderHintInput result = new CategoryOrderHintInput();
      result.uuid = this.uuid;
      result.orderHint = this.orderHint;
      return result;
    }

    public Builder uuid(String uuid) {
      this.uuid = uuid;
      return this;
    }

    public Builder orderHint(String orderHint) {
      this.orderHint = orderHint;
      return this;
    }
  }
}
