package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class CategoryUpdateAction {
  private AddCategoryAsset addAsset;

  private ChangeCategoryAssetName changeAssetName;

  private ChangeCategoryAssetOrder changeAssetOrder;

  private ChangeCategoryName changeName;

  private ChangeCategoryOrderHint changeOrderHint;

  private ChangeCategorySlug changeSlug;

  private ChangeCategoryParent changeParent;

  private RemoveCategoryAsset removeAsset;

  private SetCategoryAssetCustomField setAssetCustomField;

  private SetCategoryAssetCustomType setAssetCustomType;

  private SetCategoryAssetDescription setAssetDescription;

  private SetCategoryAssetKey setAssetKey;

  private SetCategoryAssetSources setAssetSources;

  private SetCategoryAssetTags setAssetTags;

  private SetCategoryCustomField setCustomField;

  private SetCategoryCustomType setCustomType;

  private SetCategoryDescription setDescription;

  private SetCategoryKey setKey;

  private SetCategoryMetaDescription setMetaDescription;

  private SetCategoryMetaKeywords setMetaKeywords;

  private SetCategoryMetaTitle setMetaTitle;

  private SetCategoryExternalId setExternalId;

  public CategoryUpdateAction() {
  }

  public CategoryUpdateAction(AddCategoryAsset addAsset, ChangeCategoryAssetName changeAssetName,
      ChangeCategoryAssetOrder changeAssetOrder, ChangeCategoryName changeName,
      ChangeCategoryOrderHint changeOrderHint, ChangeCategorySlug changeSlug,
      ChangeCategoryParent changeParent, RemoveCategoryAsset removeAsset,
      SetCategoryAssetCustomField setAssetCustomField,
      SetCategoryAssetCustomType setAssetCustomType,
      SetCategoryAssetDescription setAssetDescription, SetCategoryAssetKey setAssetKey,
      SetCategoryAssetSources setAssetSources, SetCategoryAssetTags setAssetTags,
      SetCategoryCustomField setCustomField, SetCategoryCustomType setCustomType,
      SetCategoryDescription setDescription, SetCategoryKey setKey,
      SetCategoryMetaDescription setMetaDescription, SetCategoryMetaKeywords setMetaKeywords,
      SetCategoryMetaTitle setMetaTitle, SetCategoryExternalId setExternalId) {
    this.addAsset = addAsset;
    this.changeAssetName = changeAssetName;
    this.changeAssetOrder = changeAssetOrder;
    this.changeName = changeName;
    this.changeOrderHint = changeOrderHint;
    this.changeSlug = changeSlug;
    this.changeParent = changeParent;
    this.removeAsset = removeAsset;
    this.setAssetCustomField = setAssetCustomField;
    this.setAssetCustomType = setAssetCustomType;
    this.setAssetDescription = setAssetDescription;
    this.setAssetKey = setAssetKey;
    this.setAssetSources = setAssetSources;
    this.setAssetTags = setAssetTags;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDescription = setDescription;
    this.setKey = setKey;
    this.setMetaDescription = setMetaDescription;
    this.setMetaKeywords = setMetaKeywords;
    this.setMetaTitle = setMetaTitle;
    this.setExternalId = setExternalId;
  }

  public AddCategoryAsset getAddAsset() {
    return addAsset;
  }

  public void setAddAsset(AddCategoryAsset addAsset) {
    this.addAsset = addAsset;
  }

  public ChangeCategoryAssetName getChangeAssetName() {
    return changeAssetName;
  }

  public void setChangeAssetName(ChangeCategoryAssetName changeAssetName) {
    this.changeAssetName = changeAssetName;
  }

  public ChangeCategoryAssetOrder getChangeAssetOrder() {
    return changeAssetOrder;
  }

  public void setChangeAssetOrder(ChangeCategoryAssetOrder changeAssetOrder) {
    this.changeAssetOrder = changeAssetOrder;
  }

  public ChangeCategoryName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeCategoryName changeName) {
    this.changeName = changeName;
  }

  public ChangeCategoryOrderHint getChangeOrderHint() {
    return changeOrderHint;
  }

  public void setChangeOrderHint(ChangeCategoryOrderHint changeOrderHint) {
    this.changeOrderHint = changeOrderHint;
  }

  public ChangeCategorySlug getChangeSlug() {
    return changeSlug;
  }

  public void setChangeSlug(ChangeCategorySlug changeSlug) {
    this.changeSlug = changeSlug;
  }

  public ChangeCategoryParent getChangeParent() {
    return changeParent;
  }

  public void setChangeParent(ChangeCategoryParent changeParent) {
    this.changeParent = changeParent;
  }

  public RemoveCategoryAsset getRemoveAsset() {
    return removeAsset;
  }

  public void setRemoveAsset(RemoveCategoryAsset removeAsset) {
    this.removeAsset = removeAsset;
  }

  public SetCategoryAssetCustomField getSetAssetCustomField() {
    return setAssetCustomField;
  }

  public void setSetAssetCustomField(SetCategoryAssetCustomField setAssetCustomField) {
    this.setAssetCustomField = setAssetCustomField;
  }

  public SetCategoryAssetCustomType getSetAssetCustomType() {
    return setAssetCustomType;
  }

  public void setSetAssetCustomType(SetCategoryAssetCustomType setAssetCustomType) {
    this.setAssetCustomType = setAssetCustomType;
  }

  public SetCategoryAssetDescription getSetAssetDescription() {
    return setAssetDescription;
  }

  public void setSetAssetDescription(SetCategoryAssetDescription setAssetDescription) {
    this.setAssetDescription = setAssetDescription;
  }

  public SetCategoryAssetKey getSetAssetKey() {
    return setAssetKey;
  }

  public void setSetAssetKey(SetCategoryAssetKey setAssetKey) {
    this.setAssetKey = setAssetKey;
  }

  public SetCategoryAssetSources getSetAssetSources() {
    return setAssetSources;
  }

  public void setSetAssetSources(SetCategoryAssetSources setAssetSources) {
    this.setAssetSources = setAssetSources;
  }

  public SetCategoryAssetTags getSetAssetTags() {
    return setAssetTags;
  }

  public void setSetAssetTags(SetCategoryAssetTags setAssetTags) {
    this.setAssetTags = setAssetTags;
  }

  public SetCategoryCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetCategoryCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetCategoryCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetCategoryCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetCategoryDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetCategoryDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetCategoryKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetCategoryKey setKey) {
    this.setKey = setKey;
  }

  public SetCategoryMetaDescription getSetMetaDescription() {
    return setMetaDescription;
  }

  public void setSetMetaDescription(SetCategoryMetaDescription setMetaDescription) {
    this.setMetaDescription = setMetaDescription;
  }

  public SetCategoryMetaKeywords getSetMetaKeywords() {
    return setMetaKeywords;
  }

  public void setSetMetaKeywords(SetCategoryMetaKeywords setMetaKeywords) {
    this.setMetaKeywords = setMetaKeywords;
  }

  public SetCategoryMetaTitle getSetMetaTitle() {
    return setMetaTitle;
  }

  public void setSetMetaTitle(SetCategoryMetaTitle setMetaTitle) {
    this.setMetaTitle = setMetaTitle;
  }

  public SetCategoryExternalId getSetExternalId() {
    return setExternalId;
  }

  public void setSetExternalId(SetCategoryExternalId setExternalId) {
    this.setExternalId = setExternalId;
  }

  @Override
  public String toString() {
    return "CategoryUpdateAction{addAsset='" + addAsset + "', changeAssetName='" + changeAssetName + "', changeAssetOrder='" + changeAssetOrder + "', changeName='" + changeName + "', changeOrderHint='" + changeOrderHint + "', changeSlug='" + changeSlug + "', changeParent='" + changeParent + "', removeAsset='" + removeAsset + "', setAssetCustomField='" + setAssetCustomField + "', setAssetCustomType='" + setAssetCustomType + "', setAssetDescription='" + setAssetDescription + "', setAssetKey='" + setAssetKey + "', setAssetSources='" + setAssetSources + "', setAssetTags='" + setAssetTags + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDescription='" + setDescription + "', setKey='" + setKey + "', setMetaDescription='" + setMetaDescription + "', setMetaKeywords='" + setMetaKeywords + "', setMetaTitle='" + setMetaTitle + "', setExternalId='" + setExternalId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CategoryUpdateAction that = (CategoryUpdateAction) o;
    return Objects.equals(addAsset, that.addAsset) &&
        Objects.equals(changeAssetName, that.changeAssetName) &&
        Objects.equals(changeAssetOrder, that.changeAssetOrder) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeOrderHint, that.changeOrderHint) &&
        Objects.equals(changeSlug, that.changeSlug) &&
        Objects.equals(changeParent, that.changeParent) &&
        Objects.equals(removeAsset, that.removeAsset) &&
        Objects.equals(setAssetCustomField, that.setAssetCustomField) &&
        Objects.equals(setAssetCustomType, that.setAssetCustomType) &&
        Objects.equals(setAssetDescription, that.setAssetDescription) &&
        Objects.equals(setAssetKey, that.setAssetKey) &&
        Objects.equals(setAssetSources, that.setAssetSources) &&
        Objects.equals(setAssetTags, that.setAssetTags) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setMetaDescription, that.setMetaDescription) &&
        Objects.equals(setMetaKeywords, that.setMetaKeywords) &&
        Objects.equals(setMetaTitle, that.setMetaTitle) &&
        Objects.equals(setExternalId, that.setExternalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addAsset, changeAssetName, changeAssetOrder, changeName, changeOrderHint, changeSlug, changeParent, removeAsset, setAssetCustomField, setAssetCustomType, setAssetDescription, setAssetKey, setAssetSources, setAssetTags, setCustomField, setCustomType, setDescription, setKey, setMetaDescription, setMetaKeywords, setMetaTitle, setExternalId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddCategoryAsset addAsset;

    private ChangeCategoryAssetName changeAssetName;

    private ChangeCategoryAssetOrder changeAssetOrder;

    private ChangeCategoryName changeName;

    private ChangeCategoryOrderHint changeOrderHint;

    private ChangeCategorySlug changeSlug;

    private ChangeCategoryParent changeParent;

    private RemoveCategoryAsset removeAsset;

    private SetCategoryAssetCustomField setAssetCustomField;

    private SetCategoryAssetCustomType setAssetCustomType;

    private SetCategoryAssetDescription setAssetDescription;

    private SetCategoryAssetKey setAssetKey;

    private SetCategoryAssetSources setAssetSources;

    private SetCategoryAssetTags setAssetTags;

    private SetCategoryCustomField setCustomField;

    private SetCategoryCustomType setCustomType;

    private SetCategoryDescription setDescription;

    private SetCategoryKey setKey;

    private SetCategoryMetaDescription setMetaDescription;

    private SetCategoryMetaKeywords setMetaKeywords;

    private SetCategoryMetaTitle setMetaTitle;

    private SetCategoryExternalId setExternalId;

    public CategoryUpdateAction build() {
      CategoryUpdateAction result = new CategoryUpdateAction();
      result.addAsset = this.addAsset;
      result.changeAssetName = this.changeAssetName;
      result.changeAssetOrder = this.changeAssetOrder;
      result.changeName = this.changeName;
      result.changeOrderHint = this.changeOrderHint;
      result.changeSlug = this.changeSlug;
      result.changeParent = this.changeParent;
      result.removeAsset = this.removeAsset;
      result.setAssetCustomField = this.setAssetCustomField;
      result.setAssetCustomType = this.setAssetCustomType;
      result.setAssetDescription = this.setAssetDescription;
      result.setAssetKey = this.setAssetKey;
      result.setAssetSources = this.setAssetSources;
      result.setAssetTags = this.setAssetTags;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      result.setMetaDescription = this.setMetaDescription;
      result.setMetaKeywords = this.setMetaKeywords;
      result.setMetaTitle = this.setMetaTitle;
      result.setExternalId = this.setExternalId;
      return result;
    }

    public Builder addAsset(AddCategoryAsset addAsset) {
      this.addAsset = addAsset;
      return this;
    }

    public Builder changeAssetName(ChangeCategoryAssetName changeAssetName) {
      this.changeAssetName = changeAssetName;
      return this;
    }

    public Builder changeAssetOrder(ChangeCategoryAssetOrder changeAssetOrder) {
      this.changeAssetOrder = changeAssetOrder;
      return this;
    }

    public Builder changeName(ChangeCategoryName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeOrderHint(ChangeCategoryOrderHint changeOrderHint) {
      this.changeOrderHint = changeOrderHint;
      return this;
    }

    public Builder changeSlug(ChangeCategorySlug changeSlug) {
      this.changeSlug = changeSlug;
      return this;
    }

    public Builder changeParent(ChangeCategoryParent changeParent) {
      this.changeParent = changeParent;
      return this;
    }

    public Builder removeAsset(RemoveCategoryAsset removeAsset) {
      this.removeAsset = removeAsset;
      return this;
    }

    public Builder setAssetCustomField(SetCategoryAssetCustomField setAssetCustomField) {
      this.setAssetCustomField = setAssetCustomField;
      return this;
    }

    public Builder setAssetCustomType(SetCategoryAssetCustomType setAssetCustomType) {
      this.setAssetCustomType = setAssetCustomType;
      return this;
    }

    public Builder setAssetDescription(SetCategoryAssetDescription setAssetDescription) {
      this.setAssetDescription = setAssetDescription;
      return this;
    }

    public Builder setAssetKey(SetCategoryAssetKey setAssetKey) {
      this.setAssetKey = setAssetKey;
      return this;
    }

    public Builder setAssetSources(SetCategoryAssetSources setAssetSources) {
      this.setAssetSources = setAssetSources;
      return this;
    }

    public Builder setAssetTags(SetCategoryAssetTags setAssetTags) {
      this.setAssetTags = setAssetTags;
      return this;
    }

    public Builder setCustomField(SetCategoryCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetCategoryCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setDescription(SetCategoryDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetCategoryKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setMetaDescription(SetCategoryMetaDescription setMetaDescription) {
      this.setMetaDescription = setMetaDescription;
      return this;
    }

    public Builder setMetaKeywords(SetCategoryMetaKeywords setMetaKeywords) {
      this.setMetaKeywords = setMetaKeywords;
      return this;
    }

    public Builder setMetaTitle(SetCategoryMetaTitle setMetaTitle) {
      this.setMetaTitle = setMetaTitle;
      return this;
    }

    public Builder setExternalId(SetCategoryExternalId setExternalId) {
      this.setExternalId = setExternalId;
      return this;
    }
  }
}
