package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeBusinessUnitAssociate {
  private AssociateDraft associate;

  public ChangeBusinessUnitAssociate() {
  }

  public ChangeBusinessUnitAssociate(AssociateDraft associate) {
    this.associate = associate;
  }

  public AssociateDraft getAssociate() {
    return associate;
  }

  public void setAssociate(AssociateDraft associate) {
    this.associate = associate;
  }

  @Override
  public String toString() {
    return "ChangeBusinessUnitAssociate{associate='" + associate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeBusinessUnitAssociate that = (ChangeBusinessUnitAssociate) o;
    return Objects.equals(associate, that.associate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AssociateDraft associate;

    public ChangeBusinessUnitAssociate build() {
      ChangeBusinessUnitAssociate result = new ChangeBusinessUnitAssociate();
      result.associate = this.associate;
      return result;
    }

    public Builder associate(AssociateDraft associate) {
      this.associate = associate;
      return this;
    }
  }
}
