package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeBusinessUnitAssociateMode {
  private BusinessUnitAssociateMode associateMode;

  public ChangeBusinessUnitAssociateMode() {
  }

  public ChangeBusinessUnitAssociateMode(BusinessUnitAssociateMode associateMode) {
    this.associateMode = associateMode;
  }

  public BusinessUnitAssociateMode getAssociateMode() {
    return associateMode;
  }

  public void setAssociateMode(BusinessUnitAssociateMode associateMode) {
    this.associateMode = associateMode;
  }

  @Override
  public String toString() {
    return "ChangeBusinessUnitAssociateMode{associateMode='" + associateMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeBusinessUnitAssociateMode that = (ChangeBusinessUnitAssociateMode) o;
    return Objects.equals(associateMode, that.associateMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitAssociateMode associateMode;

    public ChangeBusinessUnitAssociateMode build() {
      ChangeBusinessUnitAssociateMode result = new ChangeBusinessUnitAssociateMode();
      result.associateMode = this.associateMode;
      return result;
    }

    public Builder associateMode(BusinessUnitAssociateMode associateMode) {
      this.associateMode = associateMode;
      return this;
    }
  }
}
