package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeBusinessUnitStatus {
  private BusinessUnitStatus status;

  public ChangeBusinessUnitStatus() {
  }

  public ChangeBusinessUnitStatus(BusinessUnitStatus status) {
    this.status = status;
  }

  public BusinessUnitStatus getStatus() {
    return status;
  }

  public void setStatus(BusinessUnitStatus status) {
    this.status = status;
  }

  @Override
  public String toString() {
    return "ChangeBusinessUnitStatus{status='" + status + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeBusinessUnitStatus that = (ChangeBusinessUnitStatus) o;
    return Objects.equals(status, that.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitStatus status;

    public ChangeBusinessUnitStatus build() {
      ChangeBusinessUnitStatus result = new ChangeBusinessUnitStatus();
      result.status = this.status;
      return result;
    }

    public Builder status(BusinessUnitStatus status) {
      this.status = status;
      return this;
    }
  }
}
