package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartCustomLineItemPriceMode {
  private String customLineItemId;

  private String customLineItemKey;

  private CustomLineItemPriceMode mode;

  public ChangeCartCustomLineItemPriceMode() {
  }

  public ChangeCartCustomLineItemPriceMode(String customLineItemId, String customLineItemKey,
      CustomLineItemPriceMode mode) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.mode = mode;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public CustomLineItemPriceMode getMode() {
    return mode;
  }

  public void setMode(CustomLineItemPriceMode mode) {
    this.mode = mode;
  }

  @Override
  public String toString() {
    return "ChangeCartCustomLineItemPriceMode{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', mode='" + mode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartCustomLineItemPriceMode that = (ChangeCartCustomLineItemPriceMode) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(mode, that.mode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, mode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private CustomLineItemPriceMode mode;

    public ChangeCartCustomLineItemPriceMode build() {
      ChangeCartCustomLineItemPriceMode result = new ChangeCartCustomLineItemPriceMode();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.mode = this.mode;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder mode(CustomLineItemPriceMode mode) {
      this.mode = mode;
      return this;
    }
  }
}
