package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartCustomLineItemQuantity {
  private String customLineItemId;

  private String customLineItemKey;

  private Long quantity;

  public ChangeCartCustomLineItemQuantity() {
  }

  public ChangeCartCustomLineItemQuantity(String customLineItemId, String customLineItemKey,
      Long quantity) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.quantity = quantity;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  @Override
  public String toString() {
    return "ChangeCartCustomLineItemQuantity{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', quantity='" + quantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartCustomLineItemQuantity that = (ChangeCartCustomLineItemQuantity) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(quantity, that.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, quantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private Long quantity;

    public ChangeCartCustomLineItemQuantity build() {
      ChangeCartCustomLineItemQuantity result = new ChangeCartCustomLineItemQuantity();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.quantity = this.quantity;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }
  }
}
