package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartDiscountCartPredicate {
  private String cartPredicate;

  public ChangeCartDiscountCartPredicate() {
  }

  public ChangeCartDiscountCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  public String getCartPredicate() {
    return cartPredicate;
  }

  public void setCartPredicate(String cartPredicate) {
    this.cartPredicate = cartPredicate;
  }

  @Override
  public String toString() {
    return "ChangeCartDiscountCartPredicate{cartPredicate='" + cartPredicate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartDiscountCartPredicate that = (ChangeCartDiscountCartPredicate) o;
    return Objects.equals(cartPredicate, that.cartPredicate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cartPredicate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String cartPredicate;

    public ChangeCartDiscountCartPredicate build() {
      ChangeCartDiscountCartPredicate result = new ChangeCartDiscountCartPredicate();
      result.cartPredicate = this.cartPredicate;
      return result;
    }

    public Builder cartPredicate(String cartPredicate) {
      this.cartPredicate = cartPredicate;
      return this;
    }
  }
}
