package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartDiscountRequiresDiscountCode {
  private Boolean requiresDiscountCode;

  public ChangeCartDiscountRequiresDiscountCode() {
  }

  public ChangeCartDiscountRequiresDiscountCode(Boolean requiresDiscountCode) {
    this.requiresDiscountCode = requiresDiscountCode;
  }

  public Boolean getRequiresDiscountCode() {
    return requiresDiscountCode;
  }

  public void setRequiresDiscountCode(Boolean requiresDiscountCode) {
    this.requiresDiscountCode = requiresDiscountCode;
  }

  @Override
  public String toString() {
    return "ChangeCartDiscountRequiresDiscountCode{requiresDiscountCode='" + requiresDiscountCode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartDiscountRequiresDiscountCode that = (ChangeCartDiscountRequiresDiscountCode) o;
    return Objects.equals(requiresDiscountCode, that.requiresDiscountCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requiresDiscountCode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean requiresDiscountCode;

    public ChangeCartDiscountRequiresDiscountCode build() {
      ChangeCartDiscountRequiresDiscountCode result = new ChangeCartDiscountRequiresDiscountCode();
      result.requiresDiscountCode = this.requiresDiscountCode;
      return result;
    }

    public Builder requiresDiscountCode(Boolean requiresDiscountCode) {
      this.requiresDiscountCode = requiresDiscountCode;
      return this;
    }
  }
}
