package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartDiscountStackingMode {
  private StackingMode stackingMode;

  public ChangeCartDiscountStackingMode() {
  }

  public ChangeCartDiscountStackingMode(StackingMode stackingMode) {
    this.stackingMode = stackingMode;
  }

  public StackingMode getStackingMode() {
    return stackingMode;
  }

  public void setStackingMode(StackingMode stackingMode) {
    this.stackingMode = stackingMode;
  }

  @Override
  public String toString() {
    return "ChangeCartDiscountStackingMode{stackingMode='" + stackingMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartDiscountStackingMode that = (ChangeCartDiscountStackingMode) o;
    return Objects.equals(stackingMode, that.stackingMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stackingMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StackingMode stackingMode;

    public ChangeCartDiscountStackingMode build() {
      ChangeCartDiscountStackingMode result = new ChangeCartDiscountStackingMode();
      result.stackingMode = this.stackingMode;
      return result;
    }

    public Builder stackingMode(StackingMode stackingMode) {
      this.stackingMode = stackingMode;
      return this;
    }
  }
}
