package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartDiscountValue {
  private CartDiscountValueInput value;

  public ChangeCartDiscountValue() {
  }

  public ChangeCartDiscountValue(CartDiscountValueInput value) {
    this.value = value;
  }

  public CartDiscountValueInput getValue() {
    return value;
  }

  public void setValue(CartDiscountValueInput value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "ChangeCartDiscountValue{value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartDiscountValue that = (ChangeCartDiscountValue) o;
    return Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartDiscountValueInput value;

    public ChangeCartDiscountValue build() {
      ChangeCartDiscountValue result = new ChangeCartDiscountValue();
      result.value = this.value;
      return result;
    }

    public Builder value(CartDiscountValueInput value) {
      this.value = value;
      return this;
    }
  }
}
