package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartTaxMode {
  private TaxMode taxMode;

  public ChangeCartTaxMode() {
  }

  public ChangeCartTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  public TaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  @Override
  public String toString() {
    return "ChangeCartTaxMode{taxMode='" + taxMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartTaxMode that = (ChangeCartTaxMode) o;
    return Objects.equals(taxMode, that.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TaxMode taxMode;

    public ChangeCartTaxMode build() {
      ChangeCartTaxMode result = new ChangeCartTaxMode();
      result.taxMode = this.taxMode;
      return result;
    }

    public Builder taxMode(TaxMode taxMode) {
      this.taxMode = taxMode;
      return this;
    }
  }
}
