package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCartTaxRoundingMode {
  private RoundingMode taxRoundingMode;

  public ChangeCartTaxRoundingMode() {
  }

  public ChangeCartTaxRoundingMode(RoundingMode taxRoundingMode) {
    this.taxRoundingMode = taxRoundingMode;
  }

  public RoundingMode getTaxRoundingMode() {
    return taxRoundingMode;
  }

  public void setTaxRoundingMode(RoundingMode taxRoundingMode) {
    this.taxRoundingMode = taxRoundingMode;
  }

  @Override
  public String toString() {
    return "ChangeCartTaxRoundingMode{taxRoundingMode='" + taxRoundingMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCartTaxRoundingMode that = (ChangeCartTaxRoundingMode) o;
    return Objects.equals(taxRoundingMode, that.taxRoundingMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxRoundingMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private RoundingMode taxRoundingMode;

    public ChangeCartTaxRoundingMode build() {
      ChangeCartTaxRoundingMode result = new ChangeCartTaxRoundingMode();
      result.taxRoundingMode = this.taxRoundingMode;
      return result;
    }

    public Builder taxRoundingMode(RoundingMode taxRoundingMode) {
      this.taxRoundingMode = taxRoundingMode;
      return this;
    }
  }
}
