package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeCategoryAssetOrder {
  private List<String> assetOrder;

  public ChangeCategoryAssetOrder() {
  }

  public ChangeCategoryAssetOrder(List<String> assetOrder) {
    this.assetOrder = assetOrder;
  }

  public List<String> getAssetOrder() {
    return assetOrder;
  }

  public void setAssetOrder(List<String> assetOrder) {
    this.assetOrder = assetOrder;
  }

  @Override
  public String toString() {
    return "ChangeCategoryAssetOrder{assetOrder='" + assetOrder + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCategoryAssetOrder that = (ChangeCategoryAssetOrder) o;
    return Objects.equals(assetOrder, that.assetOrder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assetOrder);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> assetOrder;

    public ChangeCategoryAssetOrder build() {
      ChangeCategoryAssetOrder result = new ChangeCategoryAssetOrder();
      result.assetOrder = this.assetOrder;
      return result;
    }

    public Builder assetOrder(List<String> assetOrder) {
      this.assetOrder = assetOrder;
      return this;
    }
  }
}
