package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeCategoryOrderHint {
  private String orderHint;

  public ChangeCategoryOrderHint() {
  }

  public ChangeCategoryOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  public String getOrderHint() {
    return orderHint;
  }

  public void setOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  @Override
  public String toString() {
    return "ChangeCategoryOrderHint{orderHint='" + orderHint + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCategoryOrderHint that = (ChangeCategoryOrderHint) o;
    return Objects.equals(orderHint, that.orderHint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderHint);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String orderHint;

    public ChangeCategoryOrderHint build() {
      ChangeCategoryOrderHint result = new ChangeCategoryOrderHint();
      result.orderHint = this.orderHint;
      return result;
    }

    public Builder orderHint(String orderHint) {
      this.orderHint = orderHint;
      return this;
    }
  }
}
