package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeCategorySlug {
  private List<LocalizedStringItemInputType> slug;

  public ChangeCategorySlug() {
  }

  public ChangeCategorySlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  public List<LocalizedStringItemInputType> getSlug() {
    return slug;
  }

  public void setSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  @Override
  public String toString() {
    return "ChangeCategorySlug{slug='" + slug + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeCategorySlug that = (ChangeCategorySlug) o;
    return Objects.equals(slug, that.slug);
  }

  @Override
  public int hashCode() {
    return Objects.hash(slug);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> slug;

    public ChangeCategorySlug build() {
      ChangeCategorySlug result = new ChangeCategorySlug();
      result.slug = this.slug;
      return result;
    }

    public Builder slug(List<LocalizedStringItemInputType> slug) {
      this.slug = slug;
      return this;
    }
  }
}
