package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeExtensionDestination {
  private ExtensionDestinationInput destination;

  public ChangeExtensionDestination() {
  }

  public ChangeExtensionDestination(ExtensionDestinationInput destination) {
    this.destination = destination;
  }

  public ExtensionDestinationInput getDestination() {
    return destination;
  }

  public void setDestination(ExtensionDestinationInput destination) {
    this.destination = destination;
  }

  @Override
  public String toString() {
    return "ChangeExtensionDestination{destination='" + destination + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeExtensionDestination that = (ChangeExtensionDestination) o;
    return Objects.equals(destination, that.destination);
  }

  @Override
  public int hashCode() {
    return Objects.hash(destination);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ExtensionDestinationInput destination;

    public ChangeExtensionDestination build() {
      ChangeExtensionDestination result = new ChangeExtensionDestination();
      result.destination = this.destination;
      return result;
    }

    public Builder destination(ExtensionDestinationInput destination) {
      this.destination = destination;
      return this;
    }
  }
}
