package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeMyBusinessUnitParentUnit {
  private ResourceIdentifierInput parentUnit;

  public ChangeMyBusinessUnitParentUnit() {
  }

  public ChangeMyBusinessUnitParentUnit(ResourceIdentifierInput parentUnit) {
    this.parentUnit = parentUnit;
  }

  public ResourceIdentifierInput getParentUnit() {
    return parentUnit;
  }

  public void setParentUnit(ResourceIdentifierInput parentUnit) {
    this.parentUnit = parentUnit;
  }

  @Override
  public String toString() {
    return "ChangeMyBusinessUnitParentUnit{parentUnit='" + parentUnit + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeMyBusinessUnitParentUnit that = (ChangeMyBusinessUnitParentUnit) o;
    return Objects.equals(parentUnit, that.parentUnit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parentUnit);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput parentUnit;

    public ChangeMyBusinessUnitParentUnit build() {
      ChangeMyBusinessUnitParentUnit result = new ChangeMyBusinessUnitParentUnit();
      result.parentUnit = this.parentUnit;
      return result;
    }

    public Builder parentUnit(ResourceIdentifierInput parentUnit) {
      this.parentUnit = parentUnit;
      return this;
    }
  }
}
