package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeMyCartTaxMode {
  private TaxMode taxMode;

  public ChangeMyCartTaxMode() {
  }

  public ChangeMyCartTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  public TaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  @Override
  public String toString() {
    return "ChangeMyCartTaxMode{taxMode='" + taxMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeMyCartTaxMode that = (ChangeMyCartTaxMode) o;
    return Objects.equals(taxMode, that.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TaxMode taxMode;

    public ChangeMyCartTaxMode build() {
      ChangeMyCartTaxMode result = new ChangeMyCartTaxMode();
      result.taxMode = this.taxMode;
      return result;
    }

    public Builder taxMode(TaxMode taxMode) {
      this.taxMode = taxMode;
      return this;
    }
  }
}
