package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeOrderPaymentState {
  private PaymentState paymentState;

  public ChangeOrderPaymentState() {
  }

  public ChangeOrderPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  @Override
  public String toString() {
    return "ChangeOrderPaymentState{paymentState='" + paymentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeOrderPaymentState that = (ChangeOrderPaymentState) o;
    return Objects.equals(paymentState, that.paymentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PaymentState paymentState;

    public ChangeOrderPaymentState build() {
      ChangeOrderPaymentState result = new ChangeOrderPaymentState();
      result.paymentState = this.paymentState;
      return result;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }
  }
}
