package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangePaymentTransactionInteractionId {
  private String transactionId;

  private String interactionId;

  public ChangePaymentTransactionInteractionId() {
  }

  public ChangePaymentTransactionInteractionId(String transactionId, String interactionId) {
    this.transactionId = transactionId;
    this.interactionId = interactionId;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public String getInteractionId() {
    return interactionId;
  }

  public void setInteractionId(String interactionId) {
    this.interactionId = interactionId;
  }

  @Override
  public String toString() {
    return "ChangePaymentTransactionInteractionId{transactionId='" + transactionId + "', interactionId='" + interactionId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangePaymentTransactionInteractionId that = (ChangePaymentTransactionInteractionId) o;
    return Objects.equals(transactionId, that.transactionId) &&
        Objects.equals(interactionId, that.interactionId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transactionId, interactionId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String transactionId;

    private String interactionId;

    public ChangePaymentTransactionInteractionId build() {
      ChangePaymentTransactionInteractionId result = new ChangePaymentTransactionInteractionId();
      result.transactionId = this.transactionId;
      result.interactionId = this.interactionId;
      return result;
    }

    public Builder transactionId(String transactionId) {
      this.transactionId = transactionId;
      return this;
    }

    public Builder interactionId(String interactionId) {
      this.interactionId = interactionId;
      return this;
    }
  }
}
