package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProductDiscountValue {
  private ProductDiscountValueInput value;

  public ChangeProductDiscountValue() {
  }

  public ChangeProductDiscountValue(ProductDiscountValueInput value) {
    this.value = value;
  }

  public ProductDiscountValueInput getValue() {
    return value;
  }

  public void setValue(ProductDiscountValueInput value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "ChangeProductDiscountValue{value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProductDiscountValue that = (ChangeProductDiscountValue) o;
    return Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductDiscountValueInput value;

    public ChangeProductDiscountValue build() {
      ChangeProductDiscountValue result = new ChangeProductDiscountValue();
      result.value = this.value;
      return result;
    }

    public Builder value(ProductDiscountValueInput value) {
      this.value = value;
      return this;
    }
  }
}
