package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProductPrice {
  private String priceId;

  private Integer variantId;

  private String sku;

  private ProductPriceDataInput price;

  private Boolean staged = true;

  public ChangeProductPrice() {
  }

  public ChangeProductPrice(String priceId, Integer variantId, String sku,
      ProductPriceDataInput price, Boolean staged) {
    this.priceId = priceId;
    this.variantId = variantId;
    this.sku = sku;
    this.price = price;
    this.staged = staged;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public ProductPriceDataInput getPrice() {
    return price;
  }

  public void setPrice(ProductPriceDataInput price) {
    this.price = price;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "ChangeProductPrice{priceId='" + priceId + "', variantId='" + variantId + "', sku='" + sku + "', price='" + price + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProductPrice that = (ChangeProductPrice) o;
    return Objects.equals(priceId, that.priceId) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(price, that.price) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceId, variantId, sku, price, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String priceId;

    private Integer variantId;

    private String sku;

    private ProductPriceDataInput price;

    private Boolean staged = true;

    public ChangeProductPrice build() {
      ChangeProductPrice result = new ChangeProductPrice();
      result.priceId = this.priceId;
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.price = this.price;
      result.staged = this.staged;
      return result;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder price(ProductPriceDataInput price) {
      this.price = price;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
