package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

public class ChangeProjectSettingsCurrencies {
  private List<Currency> currencies;

  public ChangeProjectSettingsCurrencies() {
  }

  public ChangeProjectSettingsCurrencies(List<Currency> currencies) {
    this.currencies = currencies;
  }

  public List<Currency> getCurrencies() {
    return currencies;
  }

  public void setCurrencies(List<Currency> currencies) {
    this.currencies = currencies;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsCurrencies{currencies='" + currencies + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsCurrencies that = (ChangeProjectSettingsCurrencies) o;
    return Objects.equals(currencies, that.currencies);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currencies);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Currency> currencies;

    public ChangeProjectSettingsCurrencies build() {
      ChangeProjectSettingsCurrencies result = new ChangeProjectSettingsCurrencies();
      result.currencies = this.currencies;
      return result;
    }

    public Builder currencies(List<Currency> currencies) {
      this.currencies = currencies;
      return this;
    }
  }
}
