package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ChangeProjectSettingsLanguages {
  private List<String> languages;

  public ChangeProjectSettingsLanguages() {
  }

  public ChangeProjectSettingsLanguages(List<String> languages) {
    this.languages = languages;
  }

  public List<String> getLanguages() {
    return languages;
  }

  public void setLanguages(List<String> languages) {
    this.languages = languages;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsLanguages{languages='" + languages + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsLanguages that = (ChangeProjectSettingsLanguages) o;
    return Objects.equals(languages, that.languages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(languages);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> languages;

    public ChangeProjectSettingsLanguages build() {
      ChangeProjectSettingsLanguages result = new ChangeProjectSettingsLanguages();
      result.languages = this.languages;
      return result;
    }

    public Builder languages(List<String> languages) {
      this.languages = languages;
      return this;
    }
  }
}
