package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ChangeProjectSettingsMyBusinessUnitStatusOnCreation {
  private BusinessUnitConfigurationStatus status;

  public ChangeProjectSettingsMyBusinessUnitStatusOnCreation() {
  }

  public ChangeProjectSettingsMyBusinessUnitStatusOnCreation(
      BusinessUnitConfigurationStatus status) {
    this.status = status;
  }

  public BusinessUnitConfigurationStatus getStatus() {
    return status;
  }

  public void setStatus(BusinessUnitConfigurationStatus status) {
    this.status = status;
  }

  @Override
  public String toString() {
    return "ChangeProjectSettingsMyBusinessUnitStatusOnCreation{status='" + status + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChangeProjectSettingsMyBusinessUnitStatusOnCreation that = (ChangeProjectSettingsMyBusinessUnitStatusOnCreation) o;
    return Objects.equals(status, that.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BusinessUnitConfigurationStatus status;

    public ChangeProjectSettingsMyBusinessUnitStatusOnCreation build() {
      ChangeProjectSettingsMyBusinessUnitStatusOnCreation result = new ChangeProjectSettingsMyBusinessUnitStatusOnCreation();
      result.status = this.status;
      return result;
    }

    public Builder status(BusinessUnitConfigurationStatus status) {
      this.status = status;
      return this;
    }
  }
}
